/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;

public class QuadTableCoreDiff
implements QuadTableCore {
    protected QuadTableCore master;
    protected QuadTableCore additions;
    protected QuadTableCore deletions;

    public void clearDiff() {
        this.additions.clear();
        this.deletions.clear();
    }

    public void applyDiff() {
        QuadTableCoreDiff.applyDiff(this.master, this.additions, this.deletions);
        this.clearDiff();
    }

    public static void applyDiff(QuadTableCore target, QuadTableCore additions, QuadTableCore deletions) {
        deletions.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).forEach(target::delete);
        additions.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).forEach(target::add);
    }

    public QuadTableCoreDiff(QuadTableCore master, QuadTableCore additions, QuadTableCore deletions) {
        this.master = master;
        this.additions = additions;
        this.deletions = deletions;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Invocation of .clear() on a diff is not supported; you may use .clearDiff()");
    }

    @Override
    public void add(Quad quad) {
        this.additions.add(quad);
        this.deletions.delete(quad);
    }

    @Override
    public void delete(Quad quad) {
        this.deletions.add(quad);
        this.additions.delete(quad);
    }

    @Override
    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        return Stream.concat(this.master.find(g, s, p, o).filter(q -> !this.deletions.contains((Quad)q)), this.additions.find(g, s, p, o).filter(q -> !this.master.contains((Quad)q)));
    }

    @Override
    public Stream<Node> listGraphNodes() {
        return Stream.concat(this.master.listGraphNodes(), this.additions.listGraphNodes()).distinct().filter(g -> {
            boolean r = true;
            boolean hasDeletionsInG = this.deletions.find((Node)g, Node.ANY, Node.ANY, Node.ANY).findAny().isPresent();
            if (hasDeletionsInG) {
                r = Stream.concat(this.master.find((Node)g, Node.ANY, Node.ANY, Node.ANY), this.additions.find((Node)g, Node.ANY, Node.ANY, Node.ANY)).filter(q -> !this.deletions.contains((Quad)q)).findAny().isPresent();
            }
            return r;
        });
    }
}

