/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;

public class QuadTableWithHiddenGraphs
implements QuadTableCore {
    protected QuadTableCore quadTable;
    protected Predicate<Node> hiddenGraph;

    public QuadTableWithHiddenGraphs(QuadTableCore quadTable, Predicate<Node> hiddenGraph) {
        this.quadTable = quadTable;
        this.hiddenGraph = hiddenGraph;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Quad quad) {
        if (this.hiddenGraph.test(quad.getGraph())) {
            throw new IllegalArgumentException("Insert rejected by filter");
        }
        this.quadTable.add(quad);
    }

    @Override
    public void delete(Quad quad) {
        if (!this.hiddenGraph.test(quad.getGraph())) {
            this.quadTable.delete(quad);
        }
    }

    @Override
    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        Stream<Quad> result = this.hiddenGraph.test(g) ? Stream.empty() : this.quadTable.find(g, s, p, o).filter(quad -> !this.hiddenGraph.test(quad.getGraph()));
        return result;
    }

    @Override
    public Stream<Node> listGraphNodes() {
        return this.quadTable.listGraphNodes().filter(node -> !this.hiddenGraph.test((Node)node));
    }
}

