/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dboe.dataset.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.dboe.QuadTableFromNestedMaps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphQuads;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.system.Txn;

public class DatasetGraphQuadsImpl
extends DatasetGraphQuads {
    protected QuadTable table;
    protected PrefixMap prefixes = PrefixMapFactory.create();

    public DatasetGraphQuadsImpl() {
        this(new QuadTableFromNestedMaps());
    }

    public DatasetGraphQuadsImpl(QuadTable table) {
        this.table = table;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public void begin(TxnType type) {
        this.table.begin(TxnType.convert((TxnType)type));
    }

    public void begin(ReadWrite readWrite) {
        this.table.begin(readWrite);
    }

    public boolean promote(Transactional.Promote mode) {
        return false;
    }

    public void commit() {
        this.table.commit();
    }

    public void abort() {
        this.table.abort();
    }

    public void end() {
        this.table.end();
    }

    public ReadWrite transactionMode() {
        throw new UnsupportedOperationException();
    }

    public TxnType transactionType() {
        throw new UnsupportedOperationException();
    }

    public boolean isInTransaction() {
        boolean result = ((Transactional)this.table).isInTransaction();
        return result;
    }

    private void access(Runnable source) {
        if (this.isInTransaction()) {
            source.run();
        } else {
            Txn.executeRead((Transactional)this, source::run);
        }
    }

    private <T> T access(Supplier<T> source) {
        return (T)(this.isInTransaction() ? source.get() : Txn.calculateRead((Transactional)this, source::get));
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator result = this.access(() -> this.table.find(g, s, p, o).iterator());
        return result;
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        Node gm = g == null || Quad.isUnionGraph((Node)g) ? Node.ANY : g;
        Iterator result = Quad.isDefaultGraph((Node)gm) ? Collections.emptyIterator() : this.access(() -> this.table.find(gm, s, p, o).filter(q -> !Quad.isDefaultGraph((Node)q.getGraph())).iterator());
        return result;
    }

    public void add(Quad quad) {
        this.access(() -> this.table.add((Object)quad));
    }

    public void delete(Quad quad) {
        this.access(() -> this.table.delete((Object)quad));
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public void addGraph(Node graphName, Graph graph) {
        graph.find().forEachRemaining(t -> this.add(new Quad(graphName, t)));
    }

    public Iterator<Node> listGraphNodes() {
        return this.access(() -> this.table.listGraphNodes().iterator());
    }

    public static DatasetGraphQuadsImpl create(Iterator<Quad> it) {
        DatasetGraphQuadsImpl result = new DatasetGraphQuadsImpl();
        while (it.hasNext()) {
            Quad quad = it.next();
            result.add(quad);
        }
        return result;
    }

    public static DatasetGraphQuadsImpl create(Iterable<Quad> quads) {
        DatasetGraphQuadsImpl result = new DatasetGraphQuadsImpl();
        quads.forEach(result::add);
        return result;
    }

    public long size() {
        return this.table.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).count();
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }
}

