/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.Iterator;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.aksw.jena_sparql_api.dboe.QuadTableWithHiddenGraphs;
import org.aksw.jena_sparql_api.dboe.TripleTableCore;
import org.aksw.jena_sparql_api.dboe.TripleTableCoreFromQuadTable;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class StorageRDFBasic
implements StorageRDF {
    protected TripleTableCore tripleTable;
    protected QuadTableCore quadTable;

    public StorageRDFBasic(TripleTableCore tripleTable, QuadTableCore quadTable) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
    }

    public static StorageRDF createWithQuadsOnly(QuadTableCore quadTable) {
        return new StorageRDFBasic(new TripleTableCoreFromQuadTable(quadTable, Quad.defaultGraphIRI), new QuadTableWithHiddenGraphs(quadTable, Quad::isDefaultGraph));
    }

    public TripleTableCore getTripleTable() {
        return this.tripleTable;
    }

    public QuadTableCore getQuadTable() {
        return this.quadTable;
    }

    public void add(Triple triple) {
        this.tripleTable.add(triple);
    }

    public void delete(Triple triple) {
        this.tripleTable.delete(triple);
    }

    public boolean contains(Triple triple) {
        return this.tripleTable.contains(triple);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        return this.tripleTable.find(s, p, o).iterator();
    }

    public void add(Quad quad) {
        this.quadTable.add(quad);
    }

    public void delete(Quad quad) {
        this.quadTable.delete(quad);
    }

    public boolean contains(Quad quad) {
        return this.quadTable.contains(quad);
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.quadTable.find(g, s, p, o).iterator();
    }

    public void add(Node s, Node p, Node o) {
        this.add(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public void delete(Node s, Node p, Node o) {
        this.delete(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.contains(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public void add(Node g, Node s, Node p, Node o) {
        this.add(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }

    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }

    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.contains(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }
}

