/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCoreFromNestedMapsImpl;
import org.aksw.jena_sparql_api.dboe.TripleTableCore;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class TripleTableCoreFromNestedMapsImpl
implements TripleTableCore {
    protected Map<Node, Map<Node, Map<Node, Triple>>> store;
    protected QuadTableCoreFromNestedMapsImpl.MapSupplier mapSupplier;

    public TripleTableCoreFromNestedMapsImpl() {
        this(LinkedHashMap::new);
    }

    public TripleTableCoreFromNestedMapsImpl(QuadTableCoreFromNestedMapsImpl.MapSupplier mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.store = mapSupplier.newMap();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void add(Triple triple) {
        TripleTableCoreFromNestedMapsImpl.add(this.store, triple, this.mapSupplier);
    }

    @Override
    public void delete(Triple triple) {
        TripleTableCoreFromNestedMapsImpl.delete(this.store, triple);
    }

    @Override
    public Stream<Triple> find(Node s, Node p, Node o) {
        return TripleTableCoreFromNestedMapsImpl.find(this.store, s, p, o);
    }

    public static <T> Stream<T> find(Map<Node, Map<Node, Map<Node, T>>> store, Node s, Node p, Node o) {
        Stream result = QuadTableCoreFromNestedMapsImpl.match(QuadTableCoreFromNestedMapsImpl.match(QuadTableCoreFromNestedMapsImpl.match(Stream.of(store), QuadTableCoreFromNestedMapsImpl::isWildcard, s), QuadTableCoreFromNestedMapsImpl::isWildcard, p), QuadTableCoreFromNestedMapsImpl::isWildcard, o);
        return result;
    }

    public static void add(Map<Node, Map<Node, Map<Node, Triple>>> store, Triple triple, QuadTableCoreFromNestedMapsImpl.MapSupplier mapSupplier) {
        store.computeIfAbsent(triple.getSubject(), s -> mapSupplier.newMap()).computeIfAbsent(triple.getPredicate(), p -> mapSupplier.newMap()).computeIfAbsent(triple.getObject(), o -> triple);
    }

    public static boolean contains(Map<Node, Map<Node, Map<Node, Map<Node, Triple>>>> store, Triple triple) {
        boolean result = store.getOrDefault(triple.getSubject(), Collections.emptyMap()).getOrDefault(triple.getPredicate(), Collections.emptyMap()).containsKey(triple.getObject());
        return result;
    }

    public static void delete(Map<Node, Map<Node, Map<Node, Triple>>> store, Triple triple) {
        Map pm = store.getOrDefault(triple.getSubject(), Collections.emptyMap());
        Map om = pm.getOrDefault(triple.getPredicate(), Collections.emptyMap());
        if (om.containsKey(triple.getObject())) {
            om.remove(triple.getObject());
            if (om.isEmpty()) {
                pm.remove(triple.getPredicate());
            }
            if (pm.isEmpty()) {
                store.remove(triple.getSubject());
            }
        }
    }
}

