/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;

public class QuadTableCoreFromNestedMapsImpl
implements QuadTableCore {
    protected Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> store;
    protected MapSupplier mapSupplier;

    public QuadTableCoreFromNestedMapsImpl() {
        this(LinkedHashMap::new);
    }

    public QuadTableCoreFromNestedMapsImpl(MapSupplier mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.store = mapSupplier.newMap();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void add(Quad quad) {
        QuadTableCoreFromNestedMapsImpl.add(this.store, quad, this.mapSupplier);
    }

    @Override
    public void delete(Quad quad) {
        QuadTableCoreFromNestedMapsImpl.delete(this.store, quad);
    }

    @Override
    public boolean contains(Quad quad) {
        boolean result = QuadTableCoreFromNestedMapsImpl.contains(this.store, quad);
        return result;
    }

    @Override
    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        return QuadTableCoreFromNestedMapsImpl.find(this.store, g, s, p, o);
    }

    @Override
    public Stream<Node> listGraphNodes() {
        return this.store.keySet().stream();
    }

    public static boolean isWildcard(Node n) {
        return n == null || Node.ANY.equals((Object)n) || n.isVariable();
    }

    public static <K, V> Stream<V> match(Stream<Map<K, V>> in, Predicate<? super K> isAny, K k) {
        boolean any = isAny.test(k);
        Stream result = any ? in.flatMap(m -> m.values().stream()) : in.flatMap(m -> m.containsKey(k) ? Stream.of(m.get(k)) : Stream.empty());
        return result;
    }

    public static <K, V> Stream<Map.Entry<K, V>> matchEntries(Stream<Map<K, V>> in, Predicate<? super K> isAny, K k) {
        boolean any = isAny.test(k);
        Stream<Map.Entry<K, V>> result = any ? in.flatMap(m -> m.entrySet().stream()) : in.flatMap(m -> m.containsKey(k) ? Stream.of(new AbstractMap.SimpleEntry(k, m.get(k))) : Stream.empty());
        return result;
    }

    public static Stream<Quad> find(Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> store, Node g, Node s, Node p, Node o) {
        Stream<Quad> result = QuadTableCoreFromNestedMapsImpl.match(QuadTableCoreFromNestedMapsImpl.match(QuadTableCoreFromNestedMapsImpl.match(QuadTableCoreFromNestedMapsImpl.match(Stream.of(store), QuadTableCoreFromNestedMapsImpl::isWildcard, g), QuadTableCoreFromNestedMapsImpl::isWildcard, s), QuadTableCoreFromNestedMapsImpl::isWildcard, p), QuadTableCoreFromNestedMapsImpl::isWildcard, o);
        return result;
    }

    public static Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> copy(Stream<Quad> stream, MapSupplier mapSupplier) {
        Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> result = mapSupplier.newMap();
        stream.forEach(quad -> QuadTableCoreFromNestedMapsImpl.add(result, quad, mapSupplier));
        return result;
    }

    public static void add(Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> store, Quad quad, MapSupplier mapSupplier) {
        store.computeIfAbsent(quad.getGraph(), g -> mapSupplier.newMap()).computeIfAbsent(quad.getSubject(), s -> mapSupplier.newMap()).computeIfAbsent(quad.getPredicate(), p -> mapSupplier.newMap()).computeIfAbsent(quad.getObject(), o -> quad);
    }

    public static boolean contains(Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> store, Quad quad) {
        boolean result = store.getOrDefault(quad.getGraph(), Collections.emptyMap()).getOrDefault(quad.getSubject(), Collections.emptyMap()).getOrDefault(quad.getPredicate(), Collections.emptyMap()).containsKey(quad.getObject());
        return result;
    }

    public static void delete(Map<Node, Map<Node, Map<Node, Map<Node, Quad>>>> store, Quad quad) {
        Map sm = store.getOrDefault(quad.getGraph(), Collections.emptyMap());
        Map pm = sm.getOrDefault(quad.getSubject(), Collections.emptyMap());
        Map om = pm.getOrDefault(quad.getPredicate(), Collections.emptyMap());
        if (om.containsKey(quad.getObject())) {
            om.remove(quad.getObject());
            if (om.isEmpty()) {
                pm.remove(quad.getPredicate());
            }
            if (pm.isEmpty()) {
                sm.remove(quad.getSubject());
            }
            if (sm.isEmpty()) {
                store.remove(quad.getGraph());
            }
        }
    }

    public static interface MapSupplier {
        public <K, V> Map<K, V> newMap();
    }

    public static interface TripleMapSupplier {
        public <K, V> Map<K, V> newMap();
    }
}

