/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.impl;

import java.util.Collections;
import java.util.Iterator;
import org.aksw.jenax.arq.dataset.api.DatasetGraphOneNg;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TxnDataset2Graph;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.graph.GraphZero;
import org.apache.jena.system.G;

public class DatasetGraphOneNgImpl
extends DatasetGraphBaseFind
implements DatasetGraphOneNg {
    private final Graph graph;
    private final Node graphName;
    private final PrefixMap prefixes;
    private final DatasetGraph backingDGS;
    private final Transactional txn;
    private final boolean supportsAbort;

    public static DatasetGraphOneNg create(Node graphName, Graph graph) {
        Graph graph2 = DatasetGraphOneNgImpl.unwrap(graph);
        if (graph2 instanceof GraphView) {
            return new DatasetGraphOneNgImpl(graphName, graph, ((GraphView)graph2).getDataset());
        }
        return new DatasetGraphOneNgImpl(graphName, graph);
    }

    public static DatasetGraphOneNg create(DatasetGraph datasetGraph, Node graphName) {
        Graph graph = DatasetGraphUtils.getDefaultOrNamedGraph((DatasetGraph)datasetGraph, (Node)graphName);
        return new DatasetGraphOneNgImpl(graphName, graph, datasetGraph);
    }

    private static Graph unwrap(Graph graph) {
        while (true) {
            if (graph instanceof InfGraph) {
                graph = ((InfGraph)graph).getRawGraph();
                continue;
            }
            Graph graph2 = GraphOps.unwrapOne((Graph)graph);
            if (graph2 == graph) {
                return graph;
            }
            graph = graph2;
        }
    }

    private DatasetGraphOneNgImpl(Node graphName, Graph graph, DatasetGraph backing) {
        this(graphName, graph, backing, (Transactional)backing, backing.supportsTransactionAbort());
    }

    private DatasetGraphOneNgImpl(Node graphName, Graph graph) {
        this(graphName, graph, null, (Transactional)new TxnDataset2Graph(graph, new Graph[0]), false);
    }

    private DatasetGraphOneNgImpl(Node graphName, Graph graph, DatasetGraph backing, Transactional txn, boolean supportsAbort) {
        this.graphName = graphName;
        this.graph = graph;
        this.prefixes = Prefixes.adapt((Graph)graph);
        this.txn = txn;
        this.backingDGS = backing;
        this.supportsAbort = supportsAbort;
    }

    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    public void commit() {
        this.txn.commit();
    }

    public boolean promote(Transactional.Promote txnType) {
        return this.txn.promote(txnType);
    }

    public void abort() {
        this.txn.abort();
    }

    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    public void end() {
        this.txn.end();
    }

    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return this.supportsAbort;
    }

    public boolean containsGraph(Node graphNode) {
        return this.graphName.equals((Object)graphNode);
    }

    public Graph getDefaultGraph() {
        return GraphZero.instance();
    }

    public Graph getUnionGraph() {
        if (Quad.isDefaultGraph((Node)this.graphName)) {
            return GraphZero.instance();
        }
        return this.graph;
    }

    public Graph getGraph(Node graphNode) {
        if (DatasetGraphOneNgImpl.isDefaultGraph(graphNode)) {
            return this.getDefaultGraph();
        }
        if (Quad.isUnionGraph((Node)graphNode)) {
            return this.getUnionGraph();
        }
        if (this.graphName.equals((Object)graphNode)) {
            return this.graph;
        }
        return null;
    }

    public Iterator<Node> listGraphNodes() {
        return Collections.singleton(this.graphName).iterator();
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }

    @Override
    public Node getGraphNode() {
        return this.graphName;
    }

    public long size() {
        return Quad.isDefaultGraph((Node)this.graphName) ? 0L : 1L;
    }

    public void add(Node g, Node s, Node p, Node o) {
        if (g.equals((Object)this.graphName) || Quad.isDefaultGraph((Node)this.graphName) && Quad.isDefaultGraph((Node)g)) {
            this.graph.add(Triple.create((Node)s, (Node)p, (Node)o));
        } else {
            DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"add(named graph)");
        }
    }

    public void add(Quad quad) {
        Node g = quad.getGraph();
        if (g.equals((Object)this.graphName) || Quad.isDefaultGraph((Node)this.graphName) && Quad.isDefaultGraph((Node)g)) {
            this.graph.add(quad.asTriple());
        } else {
            DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"add(named graph)");
        }
    }

    public void delete(Node g, Node s, Node p, Node o) {
        if (g.equals((Object)this.graphName) || Quad.isDefaultGraph((Node)this.graphName) && Quad.isDefaultGraph((Node)g)) {
            this.graph.delete(Triple.create((Node)s, (Node)p, (Node)o));
        } else {
            DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"add(named graph)");
        }
    }

    public void delete(Quad quad) {
        Node g = quad.getGraph();
        if (g.equals((Object)this.graphName) || Quad.isDefaultGraph((Node)this.graphName) && Quad.isDefaultGraph((Node)g)) {
            this.graph.delete(quad.asTriple());
        } else {
            DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"add(named graph)");
        }
    }

    public void addGraph(Node graphName, Graph graph) {
        DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"addGraph");
    }

    public void removeGraph(Node graphName) {
        DatasetGraphOneNgImpl.unsupportedMethod((Object)this, (String)"removeGraph");
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        if (Quad.isDefaultGraph((Node)this.graphName)) {
            return G.triples2quads((Node)this.graphName, (Iterator)this.graph.find(s, p, o));
        }
        return Iter.nullIterator();
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        if (g.equals((Object)this.graphName) && !Quad.isDefaultGraph((Node)this.graphName)) {
            return G.triples2quads((Node)this.graphName, (Iterator)this.graph.find(s, p, o));
        }
        return Iter.nullIterator();
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        if (Quad.isDefaultGraph((Node)this.graphName)) {
            return Iter.nullIterator();
        }
        return G.triples2quads((Node)this.graphName, (Iterator)this.graph.find(s, p, o));
    }

    protected static boolean isDefaultGraph(Quad quad) {
        return DatasetGraphOneNgImpl.isDefaultGraph(quad.getGraph());
    }

    protected static boolean isDefaultGraph(Node quadGraphNode) {
        return quadGraphNode == null || Quad.isDefaultGraph((Node)quadGraphNode);
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        if (DatasetGraphOneNgImpl.isWildcard((Node)g) || g.equals((Object)this.graphName) || Quad.isDefaultGraph((Node)g) && Quad.isDefaultGraph((Node)this.graphName)) {
            return G.triples2quads((Node)this.graphName, (Iterator)this.graph.find(s, p, o));
        }
        return Iter.nullIterator();
    }

    public void close() {
        this.graph.close();
        super.close();
    }
}

