/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.diff;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.aksw.jenax.arq.dataset.diff.TransactionalSet;
import org.aksw.jenax.arq.dataset.diff.TransactionalSetDummyImpl;
import org.aksw.jenax.arq.dataset.diff.TransactionalSetImpl;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.Difference;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;

public class DatasetGraphDiff
extends DatasetGraphBase {
    protected DatasetGraph base;
    protected DatasetGraph added;
    protected DatasetGraph removed;
    protected TransactionalSet<Node> removedGraphs;
    protected TransactionalSet<Node> addedGraphs;
    protected GraphView defaultGraphViewCache = GraphView.createDefaultGraph((DatasetGraph)this);
    protected Map<Node, GraphView> namedGraphViewCache = Collections.synchronizedMap(new HashMap());

    public static DatasetGraphDiff createNonTxn(DatasetGraph base) {
        return new DatasetGraphDiff(base, DatasetGraphFactory.create(), DatasetGraphFactory.create(), new TransactionalSetDummyImpl(new LinkedHashSet()), new TransactionalSetDummyImpl(new LinkedHashSet()));
    }

    public static DatasetGraphDiff createTxn(DatasetGraph base) {
        return new DatasetGraphDiff(base, DatasetGraphFactory.createTxnMem(), DatasetGraphFactory.createTxnMem(), new TransactionalSetImpl<Node>(), new TransactionalSetImpl<Node>());
    }

    public DatasetGraphDiff(DatasetGraph base, DatasetGraph added, DatasetGraph removed, TransactionalSet<Node> removedGraphs, TransactionalSet<Node> addedGraphs) {
        this.base = base;
        this.added = added;
        this.removed = removed;
        this.removedGraphs = removedGraphs;
        this.addedGraphs = addedGraphs;
    }

    public void clearChanges() {
        this.removed.clear();
        this.added.clear();
    }

    public DatasetGraph getBase() {
        return this.base;
    }

    public DatasetGraph getAdded() {
        return this.added;
    }

    public DatasetGraph getRemoved() {
        return this.removed;
    }

    public Set<Node> getRemovedGraphs() {
        return this.removedGraphs;
    }

    public Set<Node> getAddedGraphs() {
        return this.addedGraphs;
    }

    public boolean contains(Node g, Node s, Node p, Node o) {
        boolean result = !this.removed.contains(g, s, p, o) && (this.added.contains(g, s, p, o) || this.base.contains(g, s, p, o));
        return result;
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator itBase = this.base.find(g, s, p, o);
        Iterator itActualAdded = Iter.filter((Iterator)this.added.find(g, s, p, o), quad -> !this.base.contains(quad));
        Iterator itVisibleBase = Iter.filter((Iterator)itBase, quad -> !this.removed.contains(quad));
        Iter result = Iter.concat((Iterator)itVisibleBase, (Iterator)itActualAdded);
        return result;
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        Iterator itBase = this.base.findNG(g, s, p, o);
        Iterator itActualAdded = Iter.filter((Iterator)this.added.findNG(g, s, p, o), quad -> !this.base.contains(quad));
        Iterator itVisibleBase = Iter.filter((Iterator)itBase, quad -> !this.removed.contains(quad));
        Iter result = Iter.concat((Iterator)itVisibleBase, (Iterator)itActualAdded);
        return result;
    }

    public void add(Quad quad) {
        this.removed.delete(quad);
        this.added.add(quad);
    }

    public void delete(Quad quad) {
        this.added.delete(quad);
        this.removed.add(quad);
    }

    public GraphView getDefaultGraph() {
        return this.defaultGraphViewCache;
    }

    public GraphView getGraph(Node graphNode) {
        GraphView result = this.namedGraphViewCache.computeIfAbsent(graphNode, n -> GraphView.createNamedGraph((DatasetGraph)this, (Node)n));
        return result;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator result = this.base.listGraphNodes();
        result = Iter.filter((Iterator)result, node -> !this.removedGraphs.contains(node));
        LinkedHashSet<Node> effectiveAddedGraphs = new LinkedHashSet<Node>(this.addedGraphs);
        Iterators.filter((Iterator)this.added.listGraphNodes(), gn -> !this.base.containsGraph(gn)).forEachRemaining(effectiveAddedGraphs::add);
        result = Iter.concat((Iterator)result, effectiveAddedGraphs.iterator());
        return result;
    }

    public void addGraph(Node graphNode, Graph graph) {
        this.removedGraphs.remove(graphNode);
        if (this.base.containsGraph(graphNode)) {
            Graph existing = this.base.getGraph(graphNode);
            this.added.addGraph(graphNode, (Graph)new Difference(graph, existing));
            this.removed.addGraph(graphNode, (Graph)new Difference(existing, graph));
        } else {
            this.addedGraphs.add(graphNode);
            this.removed.removeGraph(graphNode);
            this.added.addGraph(graphNode, graph);
        }
    }

    public void removeGraph(Node graphNode) {
        this.addedGraphs.remove(graphNode);
        if (this.base.containsGraph(graphNode)) {
            this.removedGraphs.add(graphNode);
            this.added.removeGraph(graphNode);
        } else {
            this.added.removeGraph(graphNode);
        }
        this.added.removeGraph(graphNode);
        this.removed.removeGraph(graphNode);
    }

    public void materialize() {
        DatasetGraphDiff.mutate((Transactional)this, DatasetGraphDiff::_materialize, this);
    }

    protected void _materialize() {
        this.removed.find().forEachRemaining(arg_0 -> ((DatasetGraph)this.base).delete(arg_0));
        this.added.find().forEachRemaining(arg_0 -> ((DatasetGraph)this.base).add(arg_0));
        this.removedGraphs.forEach(arg_0 -> ((DatasetGraph)this.base).removeGraph(arg_0));
        this.addedGraphs.forEach(arg_0 -> ((DatasetGraph)this.base).getGraph(arg_0));
        this.added.clear();
        this.addedGraphs.clear();
        this.removed.clear();
        this.removedGraphs.clear();
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return true;
    }

    public void abort() {
        this.addedGraphs.abort();
        this.removedGraphs.abort();
        this.base.abort();
        this.added.abort();
        this.removed.abort();
    }

    public void begin(ReadWrite mode) {
        this.base.begin(mode);
        this.added.begin(mode);
        this.removed.begin(mode);
        this.addedGraphs.begin(mode);
        this.removedGraphs.begin(mode);
    }

    public void commit() {
        this.removedGraphs.commit();
        this.addedGraphs.commit();
        this.removed.commit();
        this.added.commit();
        this.base.commit();
    }

    public void end() {
        this.removedGraphs.end();
        this.addedGraphs.end();
        this.removed.end();
        this.added.end();
        this.base.end();
    }

    public boolean isInTransaction() {
        return this.base.isInTransaction();
    }

    public void begin(TxnType type) {
        this.base.begin(type);
        this.added.begin(type);
        this.removed.begin(type);
        this.addedGraphs.begin(type);
        this.removedGraphs.begin(type);
    }

    public boolean promote(Transactional.Promote mode) {
        this.added.promote(mode);
        this.removed.promote(mode);
        this.addedGraphs.promote(mode);
        this.removedGraphs.promote(mode);
        boolean result = this.base.promote(mode);
        return result;
    }

    public ReadWrite transactionMode() {
        ReadWrite result = this.base.transactionMode();
        return result;
    }

    public TxnType transactionType() {
        TxnType result = this.base.transactionType();
        return result;
    }

    public static <T> void mutate(Transactional target, Consumer<T> mutator, T payload) {
        if (target.isInTransaction()) {
            if (!target.transactionMode().equals((Object)ReadWrite.WRITE)) {
                TxnType mode = target.transactionType();
                switch (mode) {
                    case WRITE: {
                        break;
                    }
                    case READ: {
                        throw new JenaTransactionException("Tried to write inside a READ transaction!");
                    }
                    case READ_COMMITTED_PROMOTE: 
                    case READ_PROMOTE: {
                        throw new RuntimeException("promotion not implemented");
                    }
                }
            }
            mutator.accept(payload);
        } else {
            Txn.executeWrite((Transactional)target, () -> mutator.accept(payload));
        }
    }

    public PrefixMap prefixes() {
        return this.base.prefixes();
    }
}

