/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.diff;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.aksw.jenax.arq.dataset.diff.TransactionalCollection;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRPlusSW;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;

public class TransactionalCollectionImpl<T, C extends Collection<T>>
extends AbstractCollection<T>
implements TransactionalCollection<T> {
    private Lock transactionLock = new LockMRPlusSW();
    protected AtomicReference<C> master = new AtomicReference();
    private final AtomicLong generation = new AtomicLong(0L);
    protected ThreadLocal<TxnState<T, C>> txnState = ThreadLocal.withInitial(() -> null);
    protected Function<? super C, ? extends C> cloner;

    public TransactionalCollectionImpl(C baseCollection, Function<? super C, ? extends C> cloner) {
        this.master.set(baseCollection);
        this.cloner = cloner;
    }

    public void commit() {
        TxnState<T, C> state = this.txnState.get();
        this.master.set(state.local);
    }

    public void abort() {
        this.end();
    }

    public void end() {
        this.txnState.remove();
        this.transactionLock.leaveCriticalSection();
    }

    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert((ReadWrite)readWrite));
    }

    public void begin(TxnType txnType) {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Transactions cannot be nested!");
        }
        ReadWrite txnMode = TxnType.initial((TxnType)txnType);
        this._begin(txnType, txnMode);
    }

    private void _begin(TxnType txnType, ReadWrite txnMode) {
        this.transactionLock.enterCriticalSection(txnMode.equals((Object)ReadWrite.READ));
        Collection clone = txnMode.equals((Object)ReadWrite.WRITE) ? (Collection)this.cloner.apply(this.master.get()) : (Collection)this.master.get();
        long version = this.generation.get();
        this.txnState.set(new TxnState(txnType, txnMode, clone, version));
    }

    public boolean promote(Transactional.Promote promoteMode) {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to promote outside a transaction!");
        }
        if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
            return true;
        }
        if (this.transactionType() == TxnType.READ) {
            return false;
        }
        boolean readCommitted = promoteMode == Transactional.Promote.READ_COMMITTED;
        try {
            this._promote(readCommitted);
            return true;
        }
        catch (JenaTransactionException ex) {
            return false;
        }
    }

    private void _promote(boolean readCommited) {
        if (!readCommited && this.txnState.get().version != this.generation.get()) {
            throw new JenaTransactionException("Dataset changed - can't promote");
        }
        this.transactionLock.enterCriticalSection(false);
        TxnState<T, C> local = this.txnState.get();
        if (!readCommited && local.version != this.generation.get()) {
            this.transactionLock.leaveCriticalSection();
            throw new JenaTransactionException("Concurrent writer changed the dataset : can't promote");
        }
        local.txnMode = ReadWrite.WRITE;
        this._begin(this.transactionType(), ReadWrite.WRITE);
    }

    public ReadWrite transactionMode() {
        return this.txnState.get().txnMode;
    }

    public TxnType transactionType() {
        return this.txnState.get().txnType;
    }

    public boolean isInTransaction() {
        return this.txnState.get() != null;
    }

    private <X> X access(Function<C, X> source) {
        return (X)(this.isInTransaction() ? source.apply(this.txnState.get().local) : Txn.calculateRead((Transactional)this, () -> source.apply(this.txnState.get().local)));
    }

    protected <X, R> R mutate(Function<C, R> action) {
        Object[] result = new Object[]{null};
        if (this.isInTransaction()) {
            if (!this.transactionMode().equals((Object)ReadWrite.WRITE)) {
                TxnType mode = this.transactionType();
                switch (mode) {
                    case WRITE: {
                        break;
                    }
                    case READ: {
                        throw new JenaTransactionException("Tried to write inside a READ transaction!");
                    }
                    case READ_COMMITTED_PROMOTE: 
                    case READ_PROMOTE: {
                        throw new RuntimeException("promotion not implemented");
                    }
                }
            }
            result[0] = action.apply(this.txnState.get().local);
        } else {
            Txn.executeWrite((Transactional)this, () -> {
                result[0] = action.apply(this.txnState.get().local);
            });
        }
        return (R)result[0];
    }

    @Override
    public boolean add(T e) {
        return this.mutate(c -> c.add(e));
    }

    @Override
    public Iterator<T> iterator() {
        return this.access(Collection::iterator);
    }

    @Override
    public boolean contains(Object o) {
        return this.access(c -> c.contains(o));
    }

    @Override
    public int size() {
        return this.access(Collection::size);
    }

    public static class TxnState<T, C extends Collection<T>> {
        TxnType txnType;
        ReadWrite txnMode;
        C local;
        long version;

        public TxnState(TxnType txnType, ReadWrite txnMode, C local, long version) {
            this.txnType = txnType;
            this.txnMode = txnMode;
            this.local = local;
            this.version = version;
        }
    }
}

