/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.path.relgen;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.path.core.PathOpsPE;
import org.aksw.jenax.path.core.PathPE;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.UnaryXExpr;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;

public abstract class RelationGeneratorBase {
    protected List<Fragment> pastRelations = new ArrayList<Fragment>();
    protected Fragment relation;
    protected HashCode contextHash;
    protected String contextHashStr;
    protected List<Expr> conditions = new ArrayList<Expr>();
    protected PathPE relationStartAbsPath;
    protected PathPE relPath;
    int columnIdx = 0;

    protected abstract Fragment nextInstance();

    public RelationGeneratorBase() {
        this.reset();
    }

    public Fragment process(PathPE path) {
        if (path.isAbsolute()) {
            this.reset();
        }
        this.ensureInit();
        Fragment result = this.relation;
        for (UnaryXExpr segment : path.getSegments()) {
            result = this.process(segment);
        }
        return result;
    }

    protected void reset() {
        this.setHashCode(null);
        this.pastRelations.clear();
        this.relation = null;
        this.columnIdx = 0;
        this.relationStartAbsPath = (PathPE)PathOpsPE.get().newAbsolutePath(new UnaryXExpr[0]);
        this.relPath = PathOpsPE.newRelativePath();
        this.updateHash();
    }

    public void ensureInit() {
        if (this.relation == null || this.columnIdx >= this.relation.getVars().size()) {
            String oldHash = this.contextHashStr;
            this.updateHash();
            Var pastLastVar = null;
            if (this.relation != null) {
                Fragment pastItem = this.relation.filter(this.conditions);
                pastLastVar = (Var)pastItem.getVars().get(pastItem.getVars().size() - 1);
                this.pastRelations.add(pastItem);
            }
            this.relation = this.nextInstance();
            this.relationStartAbsPath = (PathPE)this.relationStartAbsPath.resolve((Path)this.relPath);
            this.relPath = PathOpsPE.newRelativePath();
            List vars = this.relation.getVars();
            if (vars.size() <= 1) {
                throw new RuntimeException("Relations must have at least 2 variables");
            }
            this.conditions.clear();
            Var firstVar = (Var)vars.get(0);
            if (pastLastVar == null) {
                pastLastVar = Var.alloc((String)(this.contextHashStr + "_" + firstVar.getName()));
            }
            Var plv = pastLastVar;
            Map<Var, Node> remap = this.relation.getVarsMentioned().stream().collect(Collectors.toMap(v -> v, node -> {
                Var r = node.isVariable() ? (node.equals((Object)firstVar) ? plv : Var.alloc((String)(this.contextHashStr + "_" + node.getName()))) : node;
                return r;
            }));
            this.relation = this.relation.applyNodeTransform(v -> remap.getOrDefault(v, (Node)v));
            this.columnIdx = this.pastRelations.isEmpty() ? 0 : 1;
        }
    }

    public Fragment process(UnaryXExpr segment) {
        this.ensureInit();
        this.relPath = (PathPE)this.relPath.resolve(segment);
        List vars = this.relation.getVars();
        Var v = (Var)vars.get(this.columnIdx);
        ++this.columnIdx;
        if (!segment.isAlwaysTrue()) {
            Expr expr = segment.getExpr().applyNodeTransform(x -> x.isVariable() ? v : x);
            this.conditions.add(expr);
        }
        Fragment r = this.relation.filter(this.conditions);
        this.ensureInit();
        return r;
    }

    public Var getCurrentVar() {
        return (Var)this.relation.getVars().get(this.columnIdx);
    }

    public List<Fragment> getPastRelations() {
        return this.pastRelations;
    }

    public Fragment1 getCurrentConcept() {
        return new Concept(this.assemble(), this.getCurrentVar());
    }

    public Element assemble() {
        List elts = this.pastRelations.stream().flatMap(r -> r.getElements().stream()).collect(Collectors.toList());
        if (this.relation != null) {
            elts.add(this.relation.filter(this.conditions).getElement());
        }
        Element elt = ElementUtils.groupIfNeeded(elts);
        return elt;
    }

    protected void updateHash() {
        HashCode nextHashCode = this.computeNextHash(this.contextHash, this.relationStartAbsPath, this.relPath);
        this.setHashCode(nextHashCode);
    }

    protected void setHashCode(HashCode hashCode) {
        this.contextHash = hashCode;
        this.contextHashStr = hashCode == null ? null : this.encodeHashCode(hashCode);
    }

    protected String encodeHashCode(HashCode hashCode) {
        return hashCode.toString();
    }

    protected HashCode computeNextHash(HashCode currentHash, PathPE relationStartAbsPath, PathPE relPath) {
        HashCode contrib = Hashing.murmur3_32().hashString((CharSequence)relPath.toString(), StandardCharsets.UTF_8);
        HashCode result = currentHash == null ? contrib : Hashing.combineOrdered(Arrays.asList(currentHash, contrib));
        return result;
    }
}

