/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.path.core;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.commons.path.core.PathBase;
import org.aksw.commons.path.core.PathOps;
import org.aksw.jenax.path.core.FacetPathOps;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.graph.Node;

public class FacetPath
extends PathBase<FacetStep, FacetPath> {
    private static final long serialVersionUID = 1L;

    public FacetPath(PathOps<FacetStep, FacetPath> pathOps, boolean isAbsolute, List<FacetStep> segments) {
        super(pathOps, isAbsolute, segments);
    }

    public Stream<Node> streamNodes() {
        return this.getSegments().stream().filter(Objects::nonNull).map(FacetStep::getNode);
    }

    public static FacetPath parse(String str) {
        return FacetPathOps.get().fromString(str);
    }

    public static FacetPath newAbsolutePath(FacetStep segment) {
        return (FacetPath)FacetPathOps.get().newAbsolutePath(segment);
    }

    public static FacetPath newAbsolutePath(FacetStep ... segments) {
        return (FacetPath)FacetPathOps.get().newAbsolutePath(segments);
    }

    public static FacetPath newAbsolutePath(List<FacetStep> segments) {
        return (FacetPath)FacetPathOps.get().newAbsolutePath(segments);
    }

    public static FacetPath newRelativePath(FacetStep segment) {
        return (FacetPath)FacetPathOps.get().newRelativePath(segment);
    }

    public static FacetPath newRelativePath(FacetStep ... segments) {
        return (FacetPath)FacetPathOps.get().newRelativePath(segments);
    }

    public static FacetPath newRelativePath(List<FacetStep> segments) {
        return (FacetPath)FacetPathOps.get().newRelativePath(segments);
    }
}

