/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.path.core;

import java.io.Serializable;
import java.util.Objects;
import org.aksw.commons.util.direction.Direction;
import org.aksw.jenax.arq.util.node.PathUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.PathFactory;

public class FacetStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected P_Path0 step;
    protected String alias;
    protected Node targetComponent;
    public static final Var TARGET = Var.alloc((String)"target");
    public static final Var PREDICATE = Var.alloc((String)"predicate");
    public static final Var SOURCE = Var.alloc((String)"source");
    public static final Var GRAPH = Var.alloc((String)"graph");
    public static final Var TUPLE = Var.alloc((String)"tuple");
    public static Node PATH_NODE = NodeFactory.createURI((String)"urn:fragment");
    public static P_Path0 FRAGMENT_PATH = (P_Path0)PathFactory.pathLink((Node)PATH_NODE);
    public static FacetStep FRAGMENT_STEP = FacetStep.fwd(PATH_NODE);

    public static boolean isTarget(Node component) {
        return Objects.equals(TARGET, component);
    }

    public static boolean isPredicate(Node component) {
        return Objects.equals(PREDICATE, component);
    }

    public static boolean isSource(Node component) {
        return Objects.equals(SOURCE, component);
    }

    public static boolean isGraph(Node component) {
        return Objects.equals(GRAPH, component);
    }

    public static boolean isTuple(Node component) {
        return Objects.equals(TUPLE, component);
    }

    public static boolean isFragment(FacetStep facetStep) {
        return facetStep != null && FRAGMENT_PATH.equals((Object)facetStep.getStep());
    }

    public static FacetStep of(Node node, Direction direction, String alias, Node component) {
        return new FacetStep(node, direction.isForward(), alias, component);
    }

    public static FacetStep fwd(String iri) {
        return FacetStep.fwd(NodeFactory.createURI((String)iri));
    }

    public static FacetStep fwd(Resource node) {
        return FacetStep.fwd(node.asNode());
    }

    public static FacetStep fwd(Resource node, String alias) {
        return FacetStep.fwd(node.asNode(), alias);
    }

    public static FacetStep fwd(Node node) {
        return FacetStep.of(node, Direction.FORWARD, null, (Node)TARGET);
    }

    public static FacetStep fwd(Node node, String alias) {
        return FacetStep.of(node, Direction.FORWARD, alias, (Node)TARGET);
    }

    public static FacetStep bwd(String iri) {
        return FacetStep.bwd(NodeFactory.createURI((String)iri));
    }

    public static FacetStep bwd(Resource node) {
        return FacetStep.bwd(node.asNode());
    }

    public static FacetStep bwd(Resource node, String alias) {
        return FacetStep.bwd(node.asNode(), alias);
    }

    public static FacetStep bwd(Node node) {
        return FacetStep.of(node, Direction.BACKWARD, null, (Node)TARGET);
    }

    public static FacetStep bwd(Node node, String alias) {
        return FacetStep.of(node, Direction.BACKWARD, alias, (Node)TARGET);
    }

    public FacetStep(Node node, boolean isForward, String alias) {
        this(PathUtils.createStep((Node)node, (boolean)isForward), alias, (Node)TARGET);
    }

    public FacetStep(Node node, boolean isForward, String alias, Node targetComponent) {
        this(PathUtils.createStep((Node)node, (boolean)isForward), alias, targetComponent);
    }

    public FacetStep(P_Path0 step, String alias) {
        this(step, alias, null);
    }

    public FacetStep(P_Path0 step, String alias, Node targetComponent) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(targetComponent);
        this.step = step;
        this.alias = alias;
        this.targetComponent = targetComponent;
    }

    public FacetStep copyStep(Node newComponent) {
        return new FacetStep(this.step, this.alias, newComponent);
    }

    public FacetStep toggleDirection() {
        return FacetStep.of(this.getNode(), this.getDirection().opposite(), this.alias, this.targetComponent);
    }

    public P_Path0 getStep() {
        return this.step;
    }

    public Node getNode() {
        return this.step.getNode();
    }

    public Direction getDirection() {
        return Direction.ofFwd((boolean)this.isForward());
    }

    @Deprecated
    public boolean isForward() {
        return this.step.isForward();
    }

    public Node getTargetComponent() {
        return this.targetComponent;
    }

    public String getAlias() {
        return this.alias;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.targetComponent, this.step);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacetStep other = (FacetStep)obj;
        return Objects.equals(this.alias, other.alias) && this.targetComponent == other.targetComponent && Objects.equals(this.step, other.step);
    }

    public String toString() {
        return "FacetStep [step=" + String.valueOf(this.step) + ", alias=" + this.alias + ", targetComponent=" + String.valueOf(this.targetComponent) + "]";
    }
}

