/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.path.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathOps;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.path.core.PathNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFmtLib;

public class PathOpsNode
implements PathOps<Node, PathNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Node PARENT = NodeFactory.createURI((String)"..");
    public static final Node SELF = NodeFactory.createURI((String)".");
    private static PathOpsNode INSTANCE = null;

    private Object readResolve() {
        return PathOpsNode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathOpsNode get() {
        if (INSTANCE != null) return INSTANCE;
        Class<PathOpsNode> clazz = PathOpsNode.class;
        synchronized (PathOpsNode.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PathOpsNode();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static PathNode newRelativePath() {
        return PathOpsNode.get().newPath(false, Collections.emptyList());
    }

    public PathNode upcast(Path<Node> path) {
        return (PathNode)path;
    }

    public List<Node> getBasePathSegments() {
        return Collections.emptyList();
    }

    public Comparator<Node> getComparator() {
        return NodeUtils::compareAlways;
    }

    public PathNode newPath(boolean isAbsolute, List<Node> segments) {
        return new PathNode(this, isAbsolute, segments);
    }

    public Node getSelfToken() {
        return SELF;
    }

    public Node getParentToken() {
        return PARENT;
    }

    public String toStringRaw(Object path) {
        return this.toString((PathNode)((Object)path));
    }

    public String toString(PathNode path) {
        Node[] nodes = path.getSegments().stream().collect(Collectors.toList()).toArray(new Node[0]);
        String result = (path.isAbsolute() ? "/" : "") + NodeFmtLib.strNodesNT((Node[])nodes);
        return result;
    }

    public PathNode fromString(String str) {
        str = str.trim();
        boolean isAbsolute = false;
        if (str.startsWith("/")) {
            isAbsolute = true;
            str = str.substring(1);
        }
        List segments = (List)NodeUtils.parseNodes((String)str, new ArrayList());
        return this.newPath(isAbsolute, (List<Node>)segments);
    }
}

