/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.path.core;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathOps;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.path.core.PathOpsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.NodeValue;

public class FacetPathOps
implements PathOps<FacetStep, FacetPath> {
    public static final FacetStep PARENT = new FacetStep(PathOpsNode.PARENT, true, null);
    public static final FacetStep SELF = new FacetStep(PathOpsNode.SELF, true, null);
    private static FacetPathOps INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FacetPathOps get() {
        if (INSTANCE != null) return INSTANCE;
        Class<FacetPathOps> clazz = FacetPathOps.class;
        synchronized (FacetPathOps.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new FacetPathOps();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public FacetPath upcast(Path<FacetStep> path) {
        return (FacetPath)path;
    }

    public List<FacetStep> getBasePathSegments() {
        return Collections.emptyList();
    }

    public Comparator<FacetStep> getComparator() {
        return Comparator.comparing(Object::toString);
    }

    public FacetPath newPath(boolean isAbsolute, List<FacetStep> segments) {
        return new FacetPath(this, isAbsolute, segments);
    }

    public FacetStep getSelfToken() {
        return SELF;
    }

    public FacetStep getParentToken() {
        return PARENT;
    }

    public String toStringRaw(Object path) {
        return this.toString((FacetPath)((Object)path));
    }

    public static List<Node> toNodes(FacetStep step) {
        Node targetComponent;
        String alias;
        ArrayList<Node> result = new ArrayList<Node>(4);
        result.add(step.getNode());
        if (!step.isForward()) {
            result.add(NodeValue.FALSE.asNode());
        }
        if ((alias = step.getAlias()) != null && !alias.isEmpty()) {
            result.add(NodeFactory.createLiteral((String)alias));
        }
        if (!FacetStep.isTarget(targetComponent = step.getTargetComponent())) {
            result.add(targetComponent);
        }
        return result;
    }

    public String toString(FacetPath path) {
        List segments = path.getSegments();
        Node[] nodes = segments.stream().map(FacetPathOps::toNodes).flatMap(Collection::stream).collect(Collectors.toList()).toArray(new Node[0]);
        String result = (path.isAbsolute() ? "/" : "") + NodeFmtLib.strNodesTTL((Node[])nodes);
        return result;
    }

    public FacetPath fromString(String str) {
        str = str.trim();
        boolean isAbsolute = false;
        if (str.startsWith("/")) {
            isAbsolute = true;
            str = str.substring(1);
        }
        List nodes = (List)NodeUtils.parseNodes((String)str, new ArrayList());
        ArrayList<FacetStep> steps = new ArrayList<FacetStep>();
        Iterator it = nodes.iterator();
        Node current = (Node)Iterators.getNext(it, null);
        while (current != null) {
            NodeValue nv;
            boolean isFwd = true;
            String alias = null;
            Var targetComponent = FacetStep.TARGET;
            if (!current.isURI()) {
                throw new RuntimeException("Property URI expected. got: " + String.valueOf(current));
            }
            Node p = current;
            current = (Node)Iterators.getNext(it, null);
            if (current != null && current.isLiteral() && (nv = NodeValue.makeNode((Node)current)).isBoolean()) {
                isFwd = nv.getBoolean();
                current = (Node)Iterators.getNext(it, null);
            }
            if (current != null && current.isLiteral() && (nv = NodeValue.makeNode((Node)current)).isString()) {
                alias = nv.getString();
                current = (Node)Iterators.getNext(it, null);
            }
            if (current != null && current.isLiteral() && current.isVariable()) {
                targetComponent = (Var)current;
                current = (Node)Iterators.getNext(it, null);
            }
            FacetStep step = new FacetStep(p, isFwd, alias, (Node)targetComponent);
            steps.add(step);
        }
        return this.newPath(isAbsolute, steps);
    }
}

