/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.algebra.allen.AllenRelation;
import org.aksw.commons.algebra.allen.AllenRelations;
import org.aksw.commons.util.range.Cmp;
import org.aksw.commons.util.range.CmpFactory;
import org.aksw.commons.util.range.Endpoint;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.aksw.jenax.constraint.api.Domain;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.DomainNodeValue;
import org.aksw.jenax.constraint.util.NodeRanges;
import org.apache.jena.sparql.expr.ValueSpace;

public class VSpaceImpl
implements VSpace {
    protected Domain<ValueSpace, ComparableNodeValue> domain = DomainNodeValue.get();
    protected NodeRanges nodeRanges;

    protected VSpaceImpl(NodeRanges nodeRanges) {
        this.nodeRanges = nodeRanges;
    }

    @Override
    public Domain<?, ?> getDomain() {
        return this.domain;
    }

    public static VSpaceImpl create(NodeRanges nodeRanges) {
        return new VSpaceImpl(nodeRanges);
    }

    public NodeRanges getNodeRanges() {
        return this.nodeRanges;
    }

    @Override
    public VSpaceImpl clone() {
        return new VSpaceImpl(this.nodeRanges.clone());
    }

    @Override
    public boolean isLimitedTo(Object dimensionKey) {
        Set<?> vss = this.nodeRanges.getValueSpaces();
        boolean result = this.nodeRanges.isVscExhaustive() && vss.size() == 1 && vss.contains(dimensionKey);
        return result;
    }

    @Override
    public VSpaceImpl stateIntersection(VSpace valueSpace) {
        VSpaceImpl that = (VSpaceImpl)valueSpace;
        this.nodeRanges.stateIntersection(that.nodeRanges);
        return this;
    }

    @Override
    public VSpaceImpl stateUnion(VSpace valueSpace) {
        VSpaceImpl that = (VSpaceImpl)valueSpace;
        this.nodeRanges.stateUnion(that.nodeRanges);
        return this;
    }

    @Override
    public boolean isConflicting() {
        return this.nodeRanges.isConflicting();
    }

    public String toString() {
        return this.nodeRanges.toString();
    }

    @Override
    public VSpace forDimension(Object dimensionKey) {
        NodeRanges tmp = NodeRanges.createClosed();
        tmp.addOpenDimension(dimensionKey);
        VSpaceImpl vc = VSpaceImpl.create(tmp);
        VSpace result = vc.stateIntersection(this);
        return result;
    }

    @Override
    public <X extends Comparable<X>> VSpace mapDimensionToNewVSpace(Object fromDimKey, Class<X> itemType, Object toDimKey, Function<Range<X>, Range<X>> mapper) {
        Preconditions.checkArgument((boolean)ComparableNodeValue.class.isAssignableFrom(itemType), (Object)"Type must be ComparableNodeValue.class");
        TreeRangeSet ranges = this.nodeRanges.getDimension(fromDimKey);
        if (ranges == null) {
            ranges = TreeRangeSet.create();
        }
        NodeRanges newNodeRanges = NodeRanges.createClosed();
        for (Range range : ranges.asRanges()) {
            Range<X> out = mapper.apply(range);
            ValueSpace mappedDimKey = NodeRanges.classifyValueSpaceCore(out);
            if (mappedDimKey != null && !toDimKey.equals(mappedDimKey)) {
                throw new IllegalStateException("Declared target dimension was " + String.valueOf(toDimKey) + " but classified one was " + String.valueOf(mappedDimKey));
            }
            newNodeRanges.getOrCreateDimension(toDimKey).add(out);
        }
        return VSpaceImpl.create(newNodeRanges);
    }

    @Override
    public AllenRelation relateTo(VSpace that) {
        Range<Cmp<Map.Entry<?, Cmp<ComparableNodeValue>>>> thisSpan = VSpaceImpl.span(this);
        Range<Cmp<Map.Entry<?, Cmp<ComparableNodeValue>>>> thatSpan = VSpaceImpl.span(that);
        AllenRelation result = AllenRelations.compute(thisSpan, thatSpan);
        return result;
    }

    public static Range<Cmp<Map.Entry<?, Cmp<ComparableNodeValue>>>> span(VSpace vspace) {
        Objects.requireNonNull(vspace);
        Comparator cmptor = (x, y) -> ComparisonChain.start().compare(x.getKey(), y.getKey(), vspace.getDomain().getDimensionComparatorRaw()).compare((Comparable)x.getValue(), (Comparable)y.getValue()).result();
        CmpFactory dimCmpFactory = CmpFactory.of((Comparator)cmptor);
        CmpFactory cmpFactory = CmpFactory.of(ComparableNodeValue::compareTo);
        NodeRanges nr = ((VSpaceImpl)vspace).getNodeRanges();
        ArrayList dimensionKeys = nr.isVscExhaustive() ? new ArrayList(nr.getValueSpaces()) : new ArrayList(vspace.getDomain().getDimensions());
        Collections.sort(dimensionKeys, vspace.getDomain().getDimensionComparatorRaw());
        Range totalSpan = null;
        for (Object dimensionKey : dimensionKeys) {
            RangeSet ranges = nr.getDimension(dimensionKey);
            Range spanContrib = ranges == null ? Range.all() : ranges.span();
            Endpoint start = !spanContrib.hasLowerBound() ? Endpoint.open((Object)cmpFactory.minValue()) : Endpoint.of((Object)cmpFactory.wrap((Object)((ComparableNodeValue)spanContrib.lowerEndpoint())), (BoundType)spanContrib.lowerBoundType());
            Endpoint end = !spanContrib.hasUpperBound() ? Endpoint.open((Object)cmpFactory.maxValue()) : Endpoint.of((Object)cmpFactory.wrap((Object)((ComparableNodeValue)spanContrib.upperEndpoint())), (BoundType)spanContrib.upperBoundType());
            Range mappedRange = RangeUtils.create((Endpoint)start, (Endpoint)end);
            Range dimRange = RangeUtils.map((Range)mappedRange, e -> dimCmpFactory.wrap(Map.entry(dimensionKey, e)));
            if (totalSpan == null) {
                totalSpan = dimRange;
                continue;
            }
            totalSpan = totalSpan.span(dimRange);
        }
        return totalSpan;
    }
}

