/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.util;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.aksw.jenax.constraint.util.PrefixSet;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class PrefixSetImpl
extends AbstractSet<String>
implements PrefixSet {
    protected PatriciaTrie<String> trie;

    public PrefixSetImpl() {
        this((PatriciaTrie<String>)new PatriciaTrie());
    }

    public static PrefixSetImpl create(String ... strs) {
        PrefixSetImpl result = new PrefixSetImpl();
        for (String str : strs) {
            result.add(str);
        }
        return result;
    }

    @Override
    public boolean add(String e) {
        boolean result = this.trie.containsKey((Object)e);
        this.trie.put((Object)e, (Object)e);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.trie.containsKey(o);
        this.trie.remove(o);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.trie.containsKey(o);
    }

    public PrefixSetImpl(PatriciaTrie<String> trie) {
        this.trie = trie;
    }

    @Override
    public Iterator<String> iterator() {
        return this.trie.keySet().iterator();
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public Set<String> getPrefixesOf(String str, boolean inclusive) {
        Sets.SetView result = this.trie.prefixMap((Object)str).keySet();
        if (!inclusive) {
            result = Sets.difference(result, Collections.singleton(str));
        }
        return result;
    }

    @Override
    public boolean intersect(PrefixSet other) {
        Set<String> ps;
        boolean result = false;
        for (String s : other) {
            ps = this.getPrefixesOf(s, false);
            if (ps.isEmpty()) continue;
            this.removeAll(ps);
            this.add(s);
            result = true;
        }
        Iterator<String> it = this.iterator();
        while (it.hasNext()) {
            String s;
            s = it.next();
            ps = other.getPrefixesOf(s, true);
            if (!ps.isEmpty()) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        return "PrefixSetImpl [trie=" + String.valueOf(this.trie) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.trie == null ? 0 : this.trie.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixSetImpl other = (PrefixSetImpl)obj;
        return !(this.trie == null ? other.trie != null : !this.trie.equals(other.trie));
    }
}

