/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.index;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class RangeMultimaps {
    public static <K extends Comparable<K>, V, C extends Collection<V>> RangeMap<K, C> put(RangeMap<K, C> rangeMap, Range<K> key, V value, Supplier<? extends C> collectionSupplier) {
        RangeMap subRangeMap = rangeMap.subRangeMap(key);
        Map subMap = subRangeMap.asMapOfRanges();
        for (Collection c : subMap.values()) {
            c.add(value);
        }
        ImmutableRangeSet blocks = ImmutableRangeSet.copyOf(subMap.keySet());
        RangeSet gaps = blocks.complement().subRangeSet(key);
        for (Range gap : gaps.asRanges()) {
            Collection c = (Collection)collectionSupplier.get();
            c.add(value);
            rangeMap.putCoalescing(gap, (Object)c);
        }
        return rangeMap;
    }
}

