/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.impl;

import com.google.common.collect.Range;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.VSpaceImpl;
import org.aksw.jenax.constraint.util.NodeRanges;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.expr.ValueSpace;

public class RdfTermProfiles {
    public static VSpace newUnboundProfile() {
        NodeRanges nr = NodeRanges.createClosed();
        nr.addOpenDimension(ValueSpace.VSPACE_UNDEF);
        return VSpaceImpl.create(nr);
    }

    public static VSpace newOpenProfile() {
        NodeRanges nr = NodeRanges.createOpen();
        return VSpaceImpl.create(nr);
    }

    public static VSpace newIriProfile() {
        NodeRanges nr = NodeRanges.createClosed();
        nr.addOpenDimension(ValueSpace.VSPACE_URI);
        return VSpaceImpl.create(nr);
    }

    public static VSpace newLiteralProfile() {
        NodeRanges nr = NodeRanges.createOpen();
        nr.addEmptyDimension(ValueSpace.VSPACE_URI);
        nr.addEmptyDimension(ValueSpace.VSPACE_BLANKNODE);
        nr.addEmptyDimension(ValueSpace.VSPACE_TRIPLE_TERM);
        return VSpaceImpl.create(nr);
    }

    public static VSpace newNonLiteralProfile() {
        NodeRanges nr = NodeRanges.createClosed();
        nr.addOpenDimension(ValueSpace.VSPACE_URI);
        nr.addOpenDimension(ValueSpace.VSPACE_BLANKNODE);
        nr.addOpenDimension(ValueSpace.VSPACE_TRIPLE_TERM);
        return VSpaceImpl.create(nr);
    }

    public static VSpace forGraph() {
        return RdfTermProfiles.newIriProfile();
    }

    public static VSpace forSubject() {
        return RdfTermProfiles.newNonLiteralProfile();
    }

    public static VSpace forPredicate() {
        return RdfTermProfiles.newIriProfile();
    }

    public static VSpace forObject() {
        return RdfTermProfiles.newOpenProfile();
    }

    public static VSpace forNode(Node node) {
        NodeRanges nr = NodeRanges.createOpen();
        nr.stateValue(node);
        return VSpaceImpl.create(nr);
    }

    public static VSpace forStringPrefix(String prefix) {
        NodeRanges nr = NodeRanges.createClosed();
        nr.add(NodeRanges.rangeForStringPrefix(prefix));
        return VSpaceImpl.create(nr);
    }

    public static VSpace forIriPrefix(String prefix) {
        NodeRanges nr = NodeRanges.createClosed();
        Range range = RangeUtils.map(NodeRanges.rangeForStringPrefix(prefix), x -> ComparableNodeValue.wrap((Node)NodeFactory.createURI((String)x.getNodeValue().getString())));
        nr.add(range);
        return VSpaceImpl.create(nr);
    }

    public static VSpace forSlot(TupleSlot slot) {
        switch (slot) {
            case GRAPH: {
                return RdfTermProfiles.forGraph();
            }
            case SUBJECT: {
                return RdfTermProfiles.forSubject();
            }
            case PREDICATE: {
                return RdfTermProfiles.forPredicate();
            }
            case OBJECT: {
                return RdfTermProfiles.forObject();
            }
        }
        throw new IllegalArgumentException("Unsupported slot: " + String.valueOf(slot));
    }
}

