/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.util;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.sparql.expr.ValueSpace;

public abstract class VSpaceBase<T extends Comparable<T>, D> {
    protected Map<D, RangeSet<T>> vscToRangeSets;
    protected boolean isVscExhaustive;

    protected abstract D classifyValueSpace(Range<T> var1);

    protected VSpaceBase(boolean isVscExhaustive) {
        this(isVscExhaustive, new HashMap());
    }

    protected VSpaceBase(boolean isVscExhaustive, Map<D, RangeSet<T>> vscToRangeSets) {
        this.isVscExhaustive = isVscExhaustive;
        this.vscToRangeSets = vscToRangeSets;
    }

    public RangeSet<T> getDimension(Object dimensionKey) {
        return this.vscToRangeSets.get(dimensionKey);
    }

    public VSpaceBase<T, D> setDimension(Object dimensionKey, RangeSet<T> rangeSet) {
        this.vscToRangeSets.put((D)dimensionKey, (RangeSet<T>)(rangeSet == null ? null : TreeRangeSet.create(rangeSet)));
        return this;
    }

    public VSpaceBase<T, D> removeDimension(Object dimensionKey) {
        this.vscToRangeSets.remove(dimensionKey);
        return this;
    }

    public VSpaceBase<T, D> addEmptyDimension(D dimension) {
        if (!this.isVscExhaustive) {
            this.vscToRangeSets.computeIfAbsent(dimension, x -> TreeRangeSet.create());
        }
        return this;
    }

    public RangeSet<T> getOrCreateDimension(D dimension) {
        RangeSet result = this.vscToRangeSets.computeIfAbsent(dimension, x -> TreeRangeSet.create());
        return result;
    }

    public VSpaceBase<T, D> addOpenDimension(D dimension) {
        if (this.isVscExhaustive) {
            this.vscToRangeSets.computeIfAbsent(dimension, x -> TreeRangeSet.create().complement());
        }
        return this;
    }

    public boolean isUnconstrained() {
        return !this.isVscExhaustive && this.vscToRangeSets.isEmpty();
    }

    public boolean isConflicting() {
        return this.isVscExhaustive && this.vscToRangeSets.isEmpty();
    }

    public void add(Range<T> range) {
        D vsc = this.classifyValueSpace(range);
        if (ValueSpace.VSPACE_DIFFERENT.equals(vsc) && this.vscToRangeSets != null) {
            this.vscToRangeSets.clear();
            this.isVscExhaustive = true;
        } else {
            RangeSet rangeSet = this.vscToRangeSets.computeIfAbsent(vsc, x -> TreeRangeSet.create());
            rangeSet.add(range);
        }
    }

    public void substract(Range<T> range) {
        D vsc = this.classifyValueSpace(range);
        if (vsc == null) {
            this.vscToRangeSets.clear();
        } else if (!ValueSpace.VSPACE_DIFFERENT.equals(vsc) || this.vscToRangeSets == null) {
            RangeSet rangeSet = this.vscToRangeSets.computeIfAbsent(vsc, x -> TreeRangeSet.create());
            rangeSet.remove(range);
        }
    }

    public VSpaceBase<T, D> stateIntersection(VSpaceBase<T, D> that) {
        D vsc;
        if (!this.isVscExhaustive) {
            for (Map.Entry<D, RangeSet<T>> e : that.vscToRangeSets.entrySet()) {
                vsc = e.getKey();
                RangeSet<T> thatRangeSet = e.getValue();
                if (this.vscToRangeSets.containsKey(vsc)) continue;
                this.vscToRangeSets.put(vsc, thatRangeSet);
            }
        }
        Iterator<Map.Entry<D, RangeSet<T>>> it = this.vscToRangeSets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<D, RangeSet<T>> e;
            e = it.next();
            vsc = e.getKey();
            RangeSet<T> thisRangeSet = e.getValue();
            RangeSet<T> thatRangeSet = that.vscToRangeSets.get(vsc);
            if (thatRangeSet == null) {
                if (!that.isVscExhaustive) continue;
                it.remove();
                continue;
            }
            RangeSet thatComplement = thatRangeSet.complement();
            thisRangeSet.removeAll(thatComplement);
            if (!thisRangeSet.isEmpty()) continue;
            it.remove();
        }
        this.isVscExhaustive = this.isVscExhaustive || that.isVscExhaustive;
        return this;
    }

    public VSpaceBase<T, D> stateUnion(VSpaceBase<T, D> that) {
        this.isVscExhaustive = this.isVscExhaustive && that.isVscExhaustive;
        Iterator<Map.Entry<D, RangeSet<T>>> it = that.vscToRangeSets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<D, RangeSet<T>> e = it.next();
            D vsc = e.getKey();
            RangeSet<T> thatRangeSet = e.getValue();
            RangeSet thisRangeSet = this.vscToRangeSets.computeIfAbsent(vsc, x -> TreeRangeSet.create());
            thisRangeSet.addAll(thatRangeSet);
            if (this.isVscExhaustive || !thisRangeSet.complement().isEmpty()) continue;
            it.remove();
        }
        return this;
    }
}

