/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.expr.optimize.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aksw.jenax.sparql.expr.optimize.util.Alignment;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class StringAlignments {
    public static List<Alignment> toAlignment(List<Expr> a, List<List<Expr>> bs) {
        ArrayList<Alignment> result = new ArrayList<Alignment>();
        for (List<Expr> b : bs) {
            result.add(new Alignment(a, b));
        }
        return result;
    }

    public static List<Alignment> align(List<Expr> a, List<Expr> b) {
        List<Alignment> result;
        ArrayList<List<Expr>> tmp = new ArrayList<List<Expr>>();
        if (a.size() > b.size()) {
            StringAlignments.alignRec(a, 0, b, 0, tmp);
            result = StringAlignments.toAlignment(a, tmp);
        } else if (a.size() < b.size()) {
            StringAlignments.alignRec(b, 0, a, 0, tmp);
            result = StringAlignments.toAlignment(b, tmp);
        } else {
            result = Collections.singletonList(new Alignment(a, b));
        }
        return result;
    }

    public static int indexOfFirstConstant(List<Expr> a, int offset) {
        for (int i = offset; i < a.size(); ++i) {
            Expr ea = a.get(i);
            if (!ea.isConstant()) continue;
            return i;
        }
        return -1;
    }

    public static List<Expr> copyReplace(List<Expr> a, int itemIndex, String[] parts) {
        int i;
        ArrayList<Expr> result = new ArrayList<Expr>(a.size() + parts.length - 1);
        for (i = 0; i < itemIndex; ++i) {
            result.add(a.get(i));
        }
        for (i = 0; i < parts.length; ++i) {
            result.add((Expr)NodeValue.makeString((String)parts[i]));
        }
        for (i = itemIndex + 1; i < a.size(); ++i) {
            result.add(a.get(i));
        }
        return result;
    }

    public static String[] split(String str, int i, int l) {
        int n = 1;
        if (i > 0) {
            ++n;
        }
        if (i + l < str.length()) {
            ++n;
        }
        String[] result = new String[n];
        int j = 0;
        if (i > 0) {
            result[j++] = str.substring(0, i);
        }
        result[j++] = str.substring(i, i + l);
        if (i + l < str.length()) {
            result[j++] = str.substring(i + l, str.length());
        }
        return result;
    }

    public static void alignRec(List<Expr> a, int oa, List<Expr> b, int ob, List<List<Expr>> result) {
        int i = StringAlignments.indexOfFirstConstant(a, oa);
        if (i < 0) {
            result.add(b);
            return;
        }
        Expr ea = a.get(i);
        String sa = ea.getConstant().asUnquotedString();
        block0: for (int j = ob; j < b.size(); ++j) {
            Expr eb = b.get(j);
            if (!eb.isConstant()) continue;
            String sb = eb.getConstant().asUnquotedString();
            int k = 0;
            while ((k = sb.indexOf(sa, k)) >= 0) {
                if (i == 0 && k != 0) continue;
                if (i == a.size() - 1 && k + sa.length() != sb.length()) continue block0;
                String[] parts = StringAlignments.split(sb, k, sa.length());
                List<Expr> subB = StringAlignments.copyReplace(b, j, parts);
                StringAlignments.alignRec(a, i + 1, subB, j + parts.length - 1, result);
                k += sa.length();
            }
        }
    }

    public static Expr optimizeEqualsConcat2(List<Expr> la, List<Expr> lb) {
        int i;
        Expr b;
        Expr a;
        int c;
        Expr b2;
        Expr a2 = la.get(0);
        if (a2.equals((Object)(b2 = lb.get(0)))) {
            la.remove(0);
            lb.remove(0);
        } else if (a2.isConstant() && b2.isConstant()) {
            String sb;
            String sa = a2.getConstant().asUnquotedString();
            if (sa.startsWith(sb = b2.getConstant().asUnquotedString())) {
                delta = sa.substring(sb.length());
                if (delta.isEmpty()) {
                    la.remove(0);
                } else {
                    la.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                lb.remove(0);
            } else if (sb.startsWith(sa)) {
                delta = sb.substring(sa.length());
                if (delta.isEmpty()) {
                    lb.remove(0);
                } else {
                    lb.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                la.remove(0);
                lb.set(0, (Expr)NodeValue.makeString((String)delta));
            }
        }
        int n = Math.min(la.size(), lb.size());
        boolean sameLength = la.size() == lb.size();
        for (c = 0; c < n && (a = la.get(c)).equals((Object)(b = lb.get(c))); ++c) {
        }
        if (sameLength) {
            if (c == n) {
                return NodeValue.TRUE;
            }
            if (c + 1 == n) {
                return new E_Equals(la.get(c), lb.get(c));
            }
        }
        if (c == 0) {
            if (lb.size() == 0) {
                throw new IndexOutOfBoundsException();
            }
            a = la.get(0);
            b = lb.get(0);
            if (a.isConstant() && b.isConstant()) {
                return NodeValue.FALSE;
            }
            return null;
        }
        ExprList na = new ExprList();
        ExprList nb = new ExprList();
        for (i = c; i < la.size(); ++i) {
            na.add(la.get(i));
        }
        for (i = c; i < lb.size(); ++i) {
            nb.add(lb.get(i));
        }
        return new E_Equals((Expr)new E_StrConcat(na), (Expr)new E_StrConcat(nb));
    }
}

