/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.jenax.constraint.api.CBinding;
import org.aksw.jenax.constraint.api.Constrainable;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.VSpaceImpl;
import org.aksw.jenax.constraint.util.NodeRanges;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ValueSpace;

public class CBindingMap
implements CBinding {
    protected Map<Var, VSpace> varToProfile;
    VSpace vsUndef = VSpaceImpl.create(NodeRanges.createClosed().addOpenDimension(ValueSpace.VSPACE_UNDEF));

    protected CBindingMap(Map<Var, VSpace> varToProfile) {
        this.varToProfile = varToProfile;
    }

    public static CBinding create() {
        return new CBindingMap(new HashMap<Var, VSpace>());
    }

    @Override
    public Collection<Var> getVars() {
        return this.varToProfile.keySet();
    }

    @Override
    public VSpace get(Var var) {
        return this.varToProfile.get(var);
    }

    public String toString() {
        return this.varToProfile.toString();
    }

    @Override
    public CBinding cloneObject() {
        Map<Var, VSpace> map = this.varToProfile.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((VSpace)e.getValue()).clone()));
        return new CBindingMap(map);
    }

    @Override
    public boolean isConflicting() {
        boolean result = this.varToProfile.values().stream().anyMatch(Constrainable::isConflicting);
        return result;
    }

    @Override
    public CBinding stateIntersection(CBinding that) {
        HashSet<Var> vars = new HashSet<Var>();
        vars.addAll(this.getVars());
        vars.addAll(that.getVars());
        for (Var var : vars) {
            VSpace thatSpace = that.get(var);
            this.stateIntersection(var, thatSpace);
        }
        return this;
    }

    @Override
    public CBinding stateUnion(CBinding that) {
        LinkedHashSet<Var> allVars = new LinkedHashSet<Var>();
        allVars.addAll(this.getVars());
        allVars.addAll(that.getVars());
        for (Var var : allVars) {
            VSpace thisSpace = this.get(var);
            if (thisSpace == null) {
                this.stateIntersection(var, this.vsUndef);
            }
            VSpace thatSpace = that.get(var);
            this.stateUnion(var, thatSpace);
        }
        return this;
    }

    @Override
    public CBinding stateIntersection(Var var, VSpace thatSpace) {
        VSpace thisSpace = this.varToProfile.get(var);
        if (thisSpace == null) {
            this.varToProfile.put(var, thatSpace.clone());
        } else if (thatSpace != null) {
            thisSpace.stateIntersection(thatSpace);
        }
        return this;
    }

    @Override
    public CBinding stateUnion(Var var, VSpace thatSpace) {
        VSpace thisSpace = this.varToProfile.get(var);
        if (thisSpace == null) {
            this.varToProfile.put(var, thatSpace.clone());
        } else if (thatSpace != null) {
            thisSpace.stateUnion(thatSpace);
        }
        return this;
    }

    @Override
    public CBinding project(Collection<Var> vars) {
        this.varToProfile.keySet().retainAll(vars);
        return this;
    }
}

