/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.util;

import com.google.common.collect.Range;
import java.util.List;
import org.aksw.commons.util.range.Endpoint;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.constraint.api.CBinding;
import org.aksw.jenax.constraint.api.VSpace;
import org.aksw.jenax.constraint.impl.RdfTermProfiles;
import org.aksw.jenax.constraint.impl.VSpaceImpl;
import org.aksw.jenax.constraint.util.NodeRanges;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;

public class ConstraintDerivations {
    public static void deriveConstraints(CBinding row, Quad quad) {
        for (int i = 0; i < 3; ++i) {
            Node node = QuadUtils.getNode((Quad)quad, (int)i);
            if (!node.isVariable()) continue;
            Var var = (Var)node;
            TupleSlot slot = QuadUtils.idxToSlot((int)i);
            VSpace vs = RdfTermProfiles.forSlot(slot);
            row.stateIntersection(var, vs);
        }
    }

    public static void deriveConstraints(CBinding row, Triple triple) {
        for (int i = 0; i < 3; ++i) {
            Node node = TripleUtils.getNode((Triple)triple, (int)i);
            if (!node.isVariable()) continue;
            Var var = (Var)node;
            TupleSlot slot = TripleUtils.idxToSlot((int)i);
            VSpace vs = RdfTermProfiles.forSlot(slot);
            row.stateIntersection(var, vs);
        }
    }

    public static void deriveConstraints(CBinding row, VarExprList defs) {
    }

    public static void derive(CBinding row, Expr expr) {
        VSpace c = row.get(null);
    }

    public static VSpace deriveValueSpace(Expr expr, CBinding cxt) {
        VSpace result = null;
        if (expr.isConstant()) {
            NodeValue nv = expr.getConstant();
            result = VSpaceImpl.create(NodeRanges.createClosed().addValue(nv.asNode()));
        } else if (expr.isVariable()) {
            Var var = expr.asVar();
            result = cxt.get(var);
        } else {
            List args = ExprUtils.getSubExprs((Expr)expr);
            if (expr instanceof E_StrConcat) {
                if (args.isEmpty()) {
                    result = VSpaceImpl.create(NodeRanges.createClosed().addValue(NodeFactory.createLiteral((String)"")));
                } else {
                    Expr arg = (Expr)args.get(0);
                    result = ConstraintDerivations.deriveValueSpace(arg, cxt);
                    result.stateIntersection(VSpaceImpl.create(NodeRanges.createClosed().addOpenDimension(ValueSpace.VSPACE_UNDEF).addOpenDimension(ValueSpace.VSPACE_STRING)));
                }
            } else if (expr instanceof E_Str) {
                Expr arg = (Expr)args.get(0);
                result = ConstraintDerivations.deriveValueSpace(arg, cxt);
                result.stateIntersection(VSpaceImpl.create(NodeRanges.createClosed().addOpenDimension(ValueSpace.VSPACE_UNDEF).addOpenDimension(ValueSpace.VSPACE_STRING)));
            } else if (expr instanceof E_IRI) {
                Expr arg = (Expr)args.get(0);
                VSpace argSpace = ConstraintDerivations.deriveValueSpace(arg, cxt);
                result = argSpace.forDimension(ValueSpace.VSPACE_STRING);
                result = result.mapDimensionToNewVSpace(ValueSpace.VSPACE_STRING, ComparableNodeValue.class, ValueSpace.VSPACE_URI, r -> ConstraintDerivations.mapRangeToPrefix((Range<ComparableNodeValue>)r));
                if (!argSpace.isLimitedTo(ValueSpace.VSPACE_STRING)) {
                    result.stateUnion(VSpaceImpl.create(NodeRanges.createClosed().addOpenDimension(ValueSpace.VSPACE_UNDEF)));
                }
            }
        }
        if (result == null) {
            result = VSpaceImpl.create(NodeRanges.createOpen());
        }
        return result;
    }

    public static Range<ComparableNodeValue> mapRangeToPrefix(Range<ComparableNodeValue> r) {
        Range result = RangeUtils.map(r, (x, bt) -> Endpoint.closed((Object)ComparableNodeValue.wrap((Node)NodeFactory.createURI((String)x.getNodeValue().getString()))), (x, bt) -> Endpoint.open((Object)ComparableNodeValue.wrap((Node)NodeFactory.createURI((String)NodeRanges.incrementLastCharacter(x.getNodeValue().getString())))));
        return result;
    }
}

