/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.constraint.util;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.aksw.jenax.constraint.api.Contradictable;
import org.aksw.jenax.constraint.util.VSpaceBase;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;

public class NodeRanges
extends VSpaceBase<ComparableNodeValue, Object>
implements Contradictable,
Cloneable {
    public NodeRanges(boolean isVscExhaustive) {
        super(isVscExhaustive);
    }

    public NodeRanges(boolean isVscExhaustive, Map<Object, RangeSet<ComparableNodeValue>> vscToRangeSets) {
        super(isVscExhaustive, vscToRangeSets);
    }

    public RangeSet<ComparableNodeValue> getIriRanges() {
        return this.vscToRangeSets == null ? ImmutableRangeSet.of() : (RangeSet)this.vscToRangeSets.getOrDefault(ValueSpace.VSPACE_URI, ImmutableRangeSet.of());
    }

    public NodeRanges clone() {
        Map<Object, RangeSet<ComparableNodeValue>> clone = this.vscToRangeSets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> TreeRangeSet.create((RangeSet)((RangeSet)e.getValue()))));
        return new NodeRanges(this.isVscExhaustive, clone);
    }

    public static NodeRanges createOpen() {
        return new NodeRanges(false);
    }

    public static NodeRanges createClosed() {
        return new NodeRanges(true);
    }

    public NodeRanges addEmptyDimension(Object dimension) {
        super.addEmptyDimension(dimension);
        return this;
    }

    public NodeRanges addOpenDimension(Object dimension) {
        super.addOpenDimension(dimension);
        return this;
    }

    public NodeRanges stateValue(Node value) {
        ComparableNodeValue nw = ComparableNodeValue.wrap((Node)value);
        Range range = Range.singleton((Comparable)nw);
        Object vsc = this.classifyValueSpace((Range<ComparableNodeValue>)range);
        this.vscToRangeSets.keySet().retainAll(Collections.singleton(vsc));
        RangeSet ranges = (RangeSet)this.vscToRangeSets.get(vsc);
        if (ranges == null) {
            if (!this.isVscExhaustive) {
                ranges = TreeRangeSet.create();
                this.vscToRangeSets.put(vsc, ranges);
                ranges.add(range);
            }
        } else if (ranges.contains((Comparable)nw)) {
            ranges.clear();
            ranges.add(range);
        } else {
            this.vscToRangeSets.clear();
        }
        this.isVscExhaustive = true;
        return this;
    }

    public NodeRanges addValue(Node value) {
        Range range = Range.singleton((Comparable)ComparableNodeValue.wrap((Node)value));
        this.add(range);
        return this;
    }

    public boolean substractValue(Node value) {
        Range range = Range.singleton((Comparable)ComparableNodeValue.wrap((Node)value));
        Object vsc = this.classifyValueSpace((Range<ComparableNodeValue>)range);
        RangeSet ranges = (RangeSet)this.vscToRangeSets.get(vsc);
        if (ranges == null) {
            if (!this.isVscExhaustive) {
                ranges = TreeRangeSet.create();
                RangeSet tmp = ranges.complement();
                tmp.remove(range);
                this.vscToRangeSets.put(vsc, tmp);
            }
        } else {
            ranges.remove(range);
            if (this.isVscExhaustive && ranges.isEmpty()) {
                this.vscToRangeSets.remove(vsc);
            }
        }
        return this.isConflicting();
    }

    public boolean isVscExhaustive() {
        return this.isVscExhaustive;
    }

    public Set<?> getValueSpaces() {
        return this.vscToRangeSets.keySet();
    }

    public boolean contains(Node node) {
        return this.contains(NodeValue.makeNode((Node)node));
    }

    public boolean contains(NodeValue nodeValue) {
        ValueSpace vsc = nodeValue.getValueSpace();
        ComparableNodeValue tmp = ComparableNodeValue.wrap((NodeValue)nodeValue);
        boolean result = Optional.ofNullable((RangeSet)this.vscToRangeSets.get(vsc)).map(rangeSet -> rangeSet.contains((Comparable)tmp)).orElse(!this.isVscExhaustive);
        return result;
    }

    public boolean isDiscrete() {
        boolean result = this.vscToRangeSets != null && this.vscToRangeSets.values().stream().allMatch(RangeUtils::isDiscrete);
        return result;
    }

    public Stream<Node> streamDiscrete() {
        return this.vscToRangeSets.values().stream().flatMap(rangeSet -> rangeSet.asRanges().stream().map(Range::lowerEndpoint).map(ComparableNodeValue::getNode));
    }

    public boolean isConstant() {
        boolean result = this.vscToRangeSets != null && this.vscToRangeSets.size() == 1 ? RangeUtils.isSingleton((RangeSet)((RangeSet)this.vscToRangeSets.values().iterator().next())) : false;
        return result;
    }

    public Node getConstant() {
        Node result = ((ComparableNodeValue)((Range)((RangeSet)this.vscToRangeSets.values().iterator().next()).asRanges().iterator().next()).lowerEndpoint()).getNode();
        return result;
    }

    public boolean subsumes(NodeRanges other) {
        boolean result;
        if (other.isUnconstrained()) {
            result = this.isUnconstrained();
        } else if (this.isUnconstrained()) {
            result = true;
        } else {
            result = this.getValueSpaces().containsAll(other.getValueSpaces());
            if (result) {
                for (Map.Entry e : this.vscToRangeSets.entrySet()) {
                    Object vsc = e.getKey();
                    RangeSet thisRangeSet = (RangeSet)e.getValue();
                    RangeSet otherRangeSet = (RangeSet)other.vscToRangeSets.get(vsc);
                    if (otherRangeSet == null) {
                        result = false;
                        break;
                    }
                    result = thisRangeSet.enclosesAll(otherRangeSet);
                }
            }
        }
        return result;
    }

    public String toString() {
        return (this.isVscExhaustive ? "closed" : "open") + String.valueOf(this.vscToRangeSets);
    }

    @Override
    protected Object classifyValueSpace(Range<ComparableNodeValue> range) {
        return NodeRanges.classifyValueSpaceCore(range);
    }

    public static ValueSpace classifyValueSpaceCore(Range<ComparableNodeValue> range) {
        NodeValue ub;
        ValueSpace result = null;
        NodeValue lb = range.hasLowerBound() ? ((ComparableNodeValue)range.lowerEndpoint()).getNodeValue() : null;
        NodeValue nodeValue = ub = range.hasUpperBound() ? ((ComparableNodeValue)range.upperEndpoint()).getNodeValue() : null;
        if (lb != null && ub != null) {
            result = NodeValue.classifyValueOp((NodeValue)lb, (NodeValue)ub);
        } else if (lb != null) {
            result = lb.getValueSpace();
        } else if (ub != null) {
            result = ub.getValueSpace();
        }
        return result;
    }

    public static NodeRanges nodeRangesForPrefix(String prefix) {
        Range<ComparableNodeValue> range = NodeRanges.rangeForStringPrefix(prefix);
        NodeRanges result = NodeRanges.createClosed();
        result.add(range);
        return result;
    }

    public static Range<ComparableNodeValue> rangeForStringPrefix(String prefix) {
        return Range.closedOpen((Comparable)ComparableNodeValue.wrap((Node)NodeFactory.createLiteral((String)prefix)), (Comparable)ComparableNodeValue.wrap((Node)NodeFactory.createLiteral((String)NodeRanges.incrementLastCharacter(prefix))));
    }

    public static String incrementLastCharacter(String str) {
        Object result;
        int i = str.length() - 1;
        if (i < 0) {
            result = str;
        } else {
            char lastChar = str.charAt(i);
            char nextChar = (char)(lastChar + '\u0001');
            result = str.substring(0, i) + nextChar;
        }
        return result;
    }

    public static void main(String[] args) {
        Node iri = NodeFactory.createURI((String)"http://example.org/foo");
        NodeValue a = NodeValue.makeInteger((long)100L);
        NodeValue b = NodeValue.makeInteger((long)500L);
        NodeValue c = NodeValue.makeString((String)"hi");
        NodeValue d = NodeValue.makeDouble((double)123.4);
        NodeValue e = NodeValue.makeNode((Node)iri);
        NodeRanges nr = NodeRanges.createOpen();
        System.out.println(nr.isUnconstrained());
        nr.add(Range.singleton((Comparable)ComparableNodeValue.wrap((Node)iri)));
        nr.add(Range.singleton((Comparable)ComparableNodeValue.wrap((NodeValue)a)));
        System.out.println(nr.contains(b));
        System.out.println(nr.contains(c));
        System.out.println(NodeValue.compare((NodeValue)a, (NodeValue)d));
        System.out.println(nr.getValueSpaces());
        System.out.println("isDiscrete: " + nr.isDiscrete());
        System.out.println("isConstant: " + nr.isConstant());
    }
}

