/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.ext.virtuoso;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import org.aksw.jena_sparql_api.core.service.SparqlBasedSystemService;
import org.aksw.jena_sparql_api.ext.virtuoso.RDFDatasetConnectionVirtuoso;
import org.aksw.jena_sparql_api.io.utils.AbstractSystemService;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionModular;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.RDFDatasetConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtuosoSystemService
extends AbstractSystemService
implements SparqlBasedSystemService {
    private static final Logger logger = LoggerFactory.getLogger(VirtuosoSystemService.class);
    protected Path virtExecPath;
    protected Path virtIniPath;
    protected Path workingPath;
    protected transient Ini virtIni;
    protected transient Preferences virtIniPrefs;

    public VirtuosoSystemService(Path virtExecPath, Path virtIniPath) {
        this.virtExecPath = virtExecPath;
        this.virtIniPath = virtIniPath;
        this.workingPath = virtIniPath.getParent();
    }

    @Override
    public VirtuosoSystemService setOutputSink(Consumer<String> outputSink) {
        super.setOutputSink(outputSink);
        return this;
    }

    public VirtuosoSystemService setHealthCheckInterval(Duration healthCheckInterval) {
        super.setHealthCheckInterval(healthCheckInterval);
        return this;
    }

    protected ProcessBuilder prepareProcessBuilder() {
        ProcessBuilder result = new ProcessBuilder(this.virtExecPath.toString(), "-c", this.virtIniPath.toString(), "-f");
        result.directory(this.workingPath.toFile());
        return result;
    }

    protected void startUp() throws IOException, InterruptedException {
        this.virtIni = new Ini(this.virtIniPath.toFile());
        this.virtIniPrefs = new IniPreferences(this.virtIni);
        this.setOutputSink(arg_0 -> ((Logger)logger).info(arg_0));
        super.startUp();
    }

    public boolean performHealthCheck() {
        boolean result = false;
        try (RDFConnection conn = this.createDefaultConnection();){
            conn.querySelect("SELECT * { <http://example.org/healthcheck> a ?t }", qs -> {});
            result = true;
        }
        catch (Exception e) {
            logger.debug("Health check failed with reason: ", (Throwable)e);
        }
        logger.debug("Health check response: " + result);
        return result;
    }

    public static RDFConnection connectVirtuoso(String host, int httpPort, int odbcPort) {
        Connection sqlConn;
        String endpointUrl = "http://" + host + ":" + httpPort + "/sparql";
        String jdbcUrl = "jdbc:virtuoso://" + host + ":" + odbcPort;
        try {
            sqlConn = DriverManager.getConnection(jdbcUrl, "dba", "dba");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to connect to " + jdbcUrl, e);
        }
        RDFConnection httpConn = RDFConnectionFactory.connect((String)endpointUrl);
        RDFDatasetConnectionVirtuoso datasetConn = new RDFDatasetConnectionVirtuoso((SparqlQueryConnection)httpConn, sqlConn);
        RDFConnectionModular result = new RDFConnectionModular((SparqlQueryConnection)httpConn, (SparqlUpdateConnection)httpConn, (RDFDatasetConnection)datasetConn);
        return result;
    }

    @Override
    public RDFConnection createDefaultConnection() {
        int odbcPort = this.virtIniPrefs.node("Parameters").getInt("ServerPort", -1);
        int httpPort = this.virtIniPrefs.node("HTTPServer").getInt("ServerPort", -1);
        String host = "localhost";
        RDFConnection result = VirtuosoSystemService.connectVirtuoso(host, httpPort, odbcPort);
        logger.debug("Automatically detected these ports in the virtuoso configuration:");
        logger.debug("ODBC port: " + odbcPort + " --- HTTP port: " + httpPort);
        return result;
    }

    public static void main(String[] args) throws Exception {
        VirtuosoSystemService virtService = new VirtuosoSystemService(Paths.get("/opt/virtuoso/vos/7.2.4.2/bin/virtuoso-t", new String[0]), Paths.get("/opt/virtuoso/vos/7.2.4.2/databases/hobbit_1112_8891/virtuoso.ini", new String[0]));
        virtService.startAsync();
        logger.info("Waiting for startup..");
        try {
            virtService.awaitRunning(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("Failure", (Throwable)e);
            virtService.stopAsync();
            return;
        }
        logger.info("Startup complete");
        virtService.createDefaultConnection();
        Thread.sleep(5000L);
        virtService.stopAsync();
        System.err.println("Stopping...");
        virtService.awaitTerminated();
    }
}

