/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transform;

import java.util.Map;
import java.util.function.Function;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVar;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformBase;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformer;

public class StreamOpTransformSubst
extends StreamOpTransformBase {
    protected Function<String, ? extends StreamOp> varNameResolver;
    protected boolean failIfUnresolvable;

    public StreamOpTransformSubst(Function<String, ? extends StreamOp> varNameResolver) {
        this(false, varNameResolver);
    }

    public StreamOpTransformSubst(boolean failIfUnresolvable, Function<String, ? extends StreamOp> varNameResolver) {
        this.varNameResolver = varNameResolver;
        this.failIfUnresolvable = failIfUnresolvable;
    }

    @Override
    public StreamOp transform(StreamOpVar op) {
        StreamOp result;
        String varName = op.getVarName();
        StreamOp resolvedOp = this.varNameResolver.apply(varName);
        if (resolvedOp == null) {
            if (this.failIfUnresolvable) {
                throw new RuntimeException("Could not resolve " + varName);
            }
            result = resolvedOp;
        } else {
            result = op;
        }
        return result;
    }

    public static StreamOp subst(StreamOp op, Map<String, ? extends StreamOp> varNameMap) {
        return StreamOpTransformSubst.subst(op, varNameMap::get);
    }

    public static StreamOp subst(StreamOp op, Function<String, ? extends StreamOp> varNameResolver) {
        StreamOpTransformSubst transform = new StreamOpTransformSubst(varNameResolver);
        StreamOp result = StreamOpTransformer.transform(op, transform);
        return result;
    }
}

