/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.qlever;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ProxyInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);

    public static InputStream exec(String cmd) throws IOException, InterruptedException {
        return SystemUtils.exec(new ProcessBuilder(cmd));
    }

    public static InputStream exec(String ... cmd) throws IOException, InterruptedException {
        return SystemUtils.exec(new ProcessBuilder(cmd));
    }

    public static Process run(Consumer<String> logger, String ... cmd) throws IOException, InterruptedException {
        return SystemUtils.run(new ProcessBuilder(cmd), logger);
    }

    public static Process run(ProcessBuilder processBuilder, Consumer<String> logger) throws IOException, InterruptedException {
        Process process = processBuilder.redirectErrorStream(true).start();
        InputStream in = process.getInputStream();
        StreamReaderThread outputReaderThread = new StreamReaderThread(process, in);
        outputReaderThread.start();
        return process;
    }

    public static void runAndWait(Consumer<String> logger, String ... cmd) throws IOException {
        try {
            Process p = SystemUtils.run(logger, cmd);
            int exitValue = p.waitFor();
            SystemUtils.failIfNonZero(exitValue);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void failIfNonZero(Process process) {
        int exitValue = process.exitValue();
        SystemUtils.failIfNonZero(exitValue);
    }

    public static void failIfNonZero(int exitValue) {
        if (exitValue != 0) {
            throw new RuntimeException("Process exited with non-zero code: " + exitValue);
        }
    }

    public static InputStream exec(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        final Process process = processBuilder.start();
        final AtomicBoolean isTerminating = new AtomicBoolean(false);
        final int terminationWaitTimeInSeconds = 5;
        final StreamReaderThread errorReaderThread = new StreamReaderThread(process, process.getErrorStream(), isTerminating, arg_0 -> ((Logger)logger).info(arg_0));
        errorReaderThread.start();
        InputStream core = process.getInputStream();
        ProxyInputStream result = new ProxyInputStream(core){

            public void close() throws IOException {
                if (!process.isAlive()) {
                    SystemUtils.failIfNonZero(process);
                } else {
                    isTerminating.set(true);
                    process.destroy();
                    try {
                        process.waitFor(terminationWaitTimeInSeconds, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                    try {
                        process.waitFor(terminationWaitTimeInSeconds, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (process.isAlive()) {
                        throw new RuntimeException("Failed to terminate process.");
                    }
                    try {
                        errorReaderThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        super.close();
                    }
                }
            }
        };
        return result;
    }

    public static String getCommandOutput(String ... command) throws IOException {
        try {
            String result;
            InputStream in = SystemUtils.exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                result = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static String which(String commandName) throws IOException {
        return SystemUtils.getCommandOutput("which", commandName);
    }

    public static int getUID() throws IOException, NumberFormatException, InterruptedException {
        return Integer.parseInt(SystemUtils.getCommandOutput("id", "-u"));
    }

    public static int getGID() throws IOException, NumberFormatException, InterruptedException {
        return Integer.parseInt(SystemUtils.getCommandOutput("id", "-g"));
    }

    protected static class StreamReaderThread
    extends Thread {
        protected Process process;
        protected InputStream in;
        protected Consumer<String> lineConsumer;
        protected AtomicBoolean isTerminating;

        public StreamReaderThread(Process process, InputStream in) {
            this(process, in, new AtomicBoolean(), arg_0 -> ((Logger)logger).info(arg_0));
        }

        public StreamReaderThread(Process process, InputStream in, AtomicBoolean isTerminating, Consumer<String> lineHandler) {
            this.process = Objects.requireNonNull(process);
            this.in = Objects.requireNonNull(in);
            this.isTerminating = Objects.requireNonNull(isTerminating);
            this.lineConsumer = Objects.requireNonNull(lineHandler);
        }

        @Override
        public void run() {
            try (BufferedReader read = new BufferedReader(new InputStreamReader(this.in));){
                read.lines().takeWhile(x -> !this.isInterrupted()).forEach(line -> this.lineConsumer.accept((String)line));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        protected void handleException(Exception e) {
            if (this.process.isAlive() && !this.isTerminating.get()) {
                throw new RuntimeException(e);
            }
        }
    }
}

