package org.aksw.jenax.store.qlever.assembler;

import java.io.IOException;
import java.nio.file.Path;

import org.aksw.jenax.dataaccess.sparql.creator.FileSet;
import org.aksw.jenax.dataaccess.sparql.dataset.engine.DatasetGraphOverRDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.engine.qlever.RDFDatabaseBuilderQlever;
import org.aksw.jenax.engine.qlever.RdfDatabaseQlever;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.graph.GraphUtils;

import jenax.engine.qlever.docker.QleverServerConfigPojo;
import jenax.engine.qlever.docker.RDFEngineBuilderQlever;

/** */
public class DatasetAssemblerQlever
    extends DatasetAssembler
{
    @Override
    protected DatasetGraph createDataset(Assembler a, Resource root) {
        QleverServerConfigRdf res = new QleverServerConfigRdf(root.asNode(), (EnhGraph)root.getModel());

        String dockerImage = GraphUtils.getAsStringValue(root, QleverAssemblerVocab.dockerImage);
        String dockerTag   = GraphUtils.getAsStringValue(root, QleverAssemblerVocab.dockerTag);

        QleverServerConfigPojo confRun = new QleverServerConfigPojo();
        res.copyInto(confRun, false);

        // Location is currently a separate property because it needs to be fleshed out
        // how to bridge locations as strings and java nio paths (virtual file system support).
        String location = res.getLocation();
        if (location == null) {
            throw new AssemblerException(root, "Required location is missing: " + QleverAssemblerVocab.location);
        }

        String indexName = confRun.getIndexBaseName();
        if (indexName == null) {
            throw new AssemblerException(root, "Required index name is missing: " + QleverAssemblerVocab.indexName);
        }

        Path path = Path.of(location);
        FileSet fileSet = RdfDatabaseQlever.getFileSet(path, indexName);

        // If the database does not exist then create the database.
        RdfDatabaseQlever db;
        try {
            if (!fileSet.isEmpty()) {
                db = new RdfDatabaseQlever(path, indexName);
            } else {
                // Create the database if it does not exist yet
                RDFDatabaseBuilderQlever dbBuilder = new RDFDatabaseBuilderQlever();

                dbBuilder.setDockerImageName(dockerImage);
                dbBuilder.setDockerImageTag(dockerTag);

                dbBuilder.setIndexName(indexName);
                dbBuilder.setOutputFolder(path);
                // XXX Should we add support for loading initial data?
                // dbBuilder.addPath("/home/raven/Datasets/text2sparql2025/corporate-kg/corporate-kg-1.0.0-prod-inst.ttl");
                db = dbBuilder.build();
                fileSet = db.getFileSet();
            }
        } catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }

        RDFEngineBuilderQlever<?> engineBuilder = new RDFEngineBuilderQlever<>();

        RDFEngine engine;
        try {
            engine = engineBuilder
                .setImageName(dockerImage)
                .setImageTag(dockerTag)
                // .setLocation(location)
                // .setDatabase(database)
                // .setLocation(systemName)
                // .setIndexName(systemName)
                .setConfig(confRun)
                .setDatabase(db)
                .build();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        DatasetGraph result = DatasetGraphOverRDFEngine.of(engine);
        return result;
    }
}


//RDFEngine engine;
//try (Closer closer = Closer.create()) {
//  try {
//      RDFEngineBuilderQlever<?> engineBuilder = new RDFEngineBuilderQlever<>();
//      // RDFEngineFactory engineFactory = registry.getEngineFactory(systemName);
//      engine = engineBuilder
//          // .setDatabase(database)
//          // .setLocation(systemName)
//          // .setIndexName(systemName)
//          .setConfig(confRun)
//          // .setProperty("accessToken", "abcde")
//          .build();
//  } catch (Throwable t) {
//      throw closer.rethrow(t);
//  } finally {
//      closer.close();
//  }
//} catch (IOException e) {
//  throw new RuntimeException(e);
//}

