/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.aksw.shellgebra.exec.FileWriterTaskBase;

public abstract class FileWriterTaskViaExecutor
extends FileWriterTaskBase {
    protected Object lock = new Object();
    private ExecutorService executor;
    private Future<?> futureTask;

    public FileWriterTaskViaExecutor(Path path, FileWriterTaskBase.PathLifeCycle pathLifeCycle) {
        super(path, pathLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfAbortHasBeenCalled();
            this.checkIfNew();
            this.state.set(FileWriterTaskBase.TaskState.STARTING);
            this.executor = Executors.newSingleThreadExecutor();
            this.futureTask = this.executor.submit(new Worker());
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException, ExecutionException {
        if (this.state.get() == FileWriterTaskBase.TaskState.NEW) {
            throw new IllegalStateException("Task has not been started.");
        }
        if (this.futureTask != null) {
            this.futureTask.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAbortCalled) {
                boolean wasRunning;
                this.state.compareAndSet(FileWriterTaskBase.TaskState.NEW, FileWriterTaskBase.TaskState.ABORTED);
                this.isAbortCalled = true;
                boolean bl = wasRunning = this.state.get() == FileWriterTaskBase.TaskState.RUNNING;
                if (wasRunning) {
                    try {
                        try {
                            this.abortActual();
                        }
                        finally {
                            if (!this.futureTask.isDone()) {
                                this.futureTask.cancel(true);
                            }
                        }
                    }
                    finally {
                        this.state.compareAndSet(FileWriterTaskBase.TaskState.RUNNING, FileWriterTaskBase.TaskState.ABORTED);
                    }
                }
            }
        }
    }

    protected abstract void abortActual();

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public final void close() throws Exception {
        try {
            this.abort();
            this.waitForCompletion();
        }
        finally {
            try {
                this.closeActual();
            }
            finally {
                if (this.executor != null) {
                    this.executor.shutdown();
                }
            }
        }
    }

    protected void closeActual() throws Exception {
    }

    public String toString() {
        return "(executorFileWriter " + String.valueOf(this.getOutputPath()) + "/" + String.valueOf(this.pathLifeCycle) + ")";
    }

    protected class Worker
    implements Runnable {
        boolean lifeCycleStarted = false;

        protected Worker() {
        }

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            finally {
                this.cleanup();
            }
        }

        protected void cleanup() {
            if (this.lifeCycleStarted) {
                try {
                    FileWriterTaskViaExecutor.this.pathLifeCycle.afterExec(FileWriterTaskViaExecutor.this.outputPath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInternal() {
            Object object = FileWriterTaskViaExecutor.this.lock;
            synchronized (object) {
                FileWriterTaskViaExecutor.this.checkIfAbortHasBeenCalled();
                FileWriterTaskViaExecutor.this.state.set(FileWriterTaskBase.TaskState.RUNNING);
                try {
                    this.lifeCycleStarted = true;
                    FileWriterTaskViaExecutor.this.pathLifeCycle.beforeExec(FileWriterTaskViaExecutor.this.outputPath);
                    FileWriterTaskViaExecutor.this.prepareWriteFile();
                }
                catch (Exception e) {
                    FileWriterTaskViaExecutor.this.state.set(FileWriterTaskBase.TaskState.FAILED);
                    throw new RuntimeException(e);
                }
            }
            try {
                FileWriterTaskViaExecutor.this.checkIfAbortHasBeenCalled();
                FileWriterTaskViaExecutor.this.runWriteFile();
                FileWriterTaskViaExecutor.this.state.compareAndSet(FileWriterTaskBase.TaskState.RUNNING, FileWriterTaskBase.TaskState.COMPLETED);
            }
            catch (IOException e) {
                FileWriterTaskViaExecutor.this.state.compareAndSet(FileWriterTaskBase.TaskState.RUNNING, FileWriterTaskBase.TaskState.FAILED);
                throw new CompletionException(e);
            }
            finally {
                try {
                    Object object2 = FileWriterTaskViaExecutor.this.lock;
                    synchronized (object2) {
                        FileWriterTaskViaExecutor.this.onCompletion();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

