/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.aksw.jenax.engine.qlever.SystemUtils;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVar;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVisitor;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class StreamOpVisitorStream
implements StreamOpVisitor<InputStream> {
    protected CompressorStreamFactory compressorStreamFactory;
    protected SysRuntime runtime;
    private static StreamOpVisitorStream singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamOpVisitorStream getSingleton() {
        if (singleton != null) return singleton;
        Class<StreamOpVisitorStream> clazz = StreamOpVisitorStream.class;
        synchronized (StreamOpVisitorStream.class) {
            if (singleton != null) return singleton;
            singleton = new StreamOpVisitorStream();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public StreamOpVisitorStream() {
        this(CompressorStreamFactory.getSingleton());
    }

    public StreamOpVisitorStream(CompressorStreamFactory compressorStreamFactory) {
        this.compressorStreamFactory = compressorStreamFactory;
    }

    @Override
    public InputStream visit(StreamOpFile op) {
        String name = op.getPath();
        Path path = Path.of(name, new String[0]);
        try {
            return Files.newInputStream(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream visit(StreamOpTranscode op) {
        CompressorInputStream result;
        InputStream base = op.getSubOp().accept(this);
        String name = op.getName();
        try {
            result = this.compressorStreamFactory.createCompressorInputStream(name, base, true);
        }
        catch (CompressorException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public InputStream visit(StreamOpConcat op) {
        List<StreamOp> subOps = op.getSubOps();
        Vector<InputStream> v = new Vector<InputStream>(subOps.size());
        for (StreamOp subOp : subOps) {
            InputStream contrib = subOp.accept(this);
            v.add(contrib);
        }
        return new SequenceInputStream(v.elements());
    }

    @Override
    public InputStream visit(StreamOpCommand op) {
        if (this.runtime == null) {
            throw new RuntimeException("No runtime set. Cannot execute command nodes.");
        }
        CmdOp cmdOp = op.getCmdOp();
        String[] cmd = this.runtime.compileCommand(cmdOp);
        ArrayList<String> c = new ArrayList<String>();
        c.add("/usr/bin/bash");
        c.add("-c");
        c.add(SysRuntimeImpl.join(cmd));
        String[] d = c.toArray(new String[0]);
        try {
            return SystemUtils.exec(d);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream visit(StreamOpVar op) {
        throw new UnsupportedOperationException("Variable not supported: " + String.valueOf(op));
    }
}

