/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.exec.CmdStrOps;

public interface SysRuntime {
    public String which(String var1) throws IOException, InterruptedException;

    public String quoteFileArgument(String var1);

    public String[] compileCommand(CmdOp var1);

    public CmdStrOps getStrOps();

    public void createNamedPipe(Path var1) throws IOException;

    default public String[] resolveCommand(String ... cmd) throws IOException, InterruptedException {
        Objects.requireNonNull(cmd);
        if (cmd.length == 0) {
            throw new IllegalArgumentException("Command must not be an empty array.");
        }
        String cmdName = cmd[0];
        String resolvedName = this.which(cmdName);
        if (resolvedName == null) {
            throw new RuntimeException("Command not found: " + cmdName);
        }
        String[] result = Arrays.copyOf(cmd, cmd.length);
        result[0] = resolvedName;
        return result;
    }
}

