/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.aksw.shellgebra.exec.FileWriterTaskBase;
import org.aksw.shellgebra.exec.SysRuntimeImpl;

public class PathLifeCycles {
    private static final FileWriterTaskBase.PathLifeCycle NONE = new FileWriterTaskBase.PathLifeCycle(){};

    public static FileWriterTaskBase.PathLifeCycle none() {
        return NONE;
    }

    public static FileWriterTaskBase.PathLifeCycle namedPipe() {
        return new PathLifeCycleForNamedPipe();
    }

    public static FileWriterTaskBase.PathLifeCycle deleteAfterExec(FileWriterTaskBase.PathLifeCycle delegate) {
        FileWriterTaskBase.PathLifeCycle result = delegate instanceof PathLifeCycleDeleteAfterExec ? delegate : new PathLifeCycleDeleteAfterExec(delegate);
        return result;
    }

    public static class PathLifeCycleForNamedPipe
    implements FileWriterTaskBase.PathLifeCycle {
        @Override
        public void beforeExec(Path path) throws IOException {
            SysRuntimeImpl.forCurrentOs().createNamedPipe(path);
        }

        public String toString() {
            return "namedPipe";
        }
    }

    public static class PathLifeCycleDeleteAfterExec
    extends PathLifeCycleWrapperBase {
        public PathLifeCycleDeleteAfterExec(FileWriterTaskBase.PathLifeCycle delegate) {
            super(delegate);
        }

        @Override
        public void afterExec(Path path) throws IOException {
            Files.deleteIfExists(path);
        }

        public String toString() {
            return "deleteAfterExec/" + String.valueOf(this.getDelegate());
        }
    }

    public static class PathLifeCycleWrapperBase
    implements PathLifeCycleWrapper {
        protected FileWriterTaskBase.PathLifeCycle delegate;

        public PathLifeCycleWrapperBase(FileWriterTaskBase.PathLifeCycle delegate) {
            this.delegate = delegate;
        }

        @Override
        public FileWriterTaskBase.PathLifeCycle getDelegate() {
            return this.delegate;
        }
    }

    public static interface PathLifeCycleWrapper
    extends FileWriterTaskBase.PathLifeCycle {
        public FileWriterTaskBase.PathLifeCycle getDelegate();

        @Override
        default public void beforeExec(Path item) throws IOException {
            this.getDelegate().beforeExec(item);
        }

        @Override
        default public void afterExec(Path item) throws IOException {
            this.getDelegate().afterExec(item);
        }
    }
}

