/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.shellgebra.exec.FileWriterTaskBase;
import org.aksw.shellgebra.exec.FileWriterTaskViaExecutor;

public class FileWriterTaskFromByteSource
extends FileWriterTaskViaExecutor {
    protected ByteSource byteSource;

    public FileWriterTaskFromByteSource(Path path, FileWriterTaskBase.PathLifeCycle pathLifeCycle, ByteSource byteSource) {
        super(path, pathLifeCycle);
        this.byteSource = byteSource;
    }

    @Override
    protected void abortActual() {
    }

    @Override
    protected void prepareWriteFile() throws IOException {
    }

    @Override
    protected void runWriteFile() throws IOException {
        try (OutputStream out = Files.newOutputStream(this.outputPath, StandardOpenOption.WRITE);){
            try (InputStream in = this.byteSource.openStream();){
                in.transferTo(out);
            }
            out.flush();
        }
    }
}

