/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.qlever;

import java.lang.reflect.InvocationTargetException;
import org.aksw.jenax.dataaccess.sparql.creator.HasProperties;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HasBeanProperties<X>
extends HasProperties<X> {
    default public X setProperty(String key, Object value) {
        Object bean = this.self();
        try {
            PropertyUtils.setProperty((Object)bean, (String)key, (Object)value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger logger = LoggerFactory.getLogger(HasBeanProperties.class);
            logger.warn("Could not set property: (" + key + ", " + String.valueOf(value) + ") on " + String.valueOf(bean), (Throwable)e);
        }
        return (X)bean;
    }

    default public <T> T getProperty(String key) {
        Object r;
        Object bean = this.self();
        try {
            r = PropertyUtils.getProperty((Object)bean, (String)key);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Logger logger = LoggerFactory.getLogger(HasBeanProperties.class);
            logger.warn("No such property " + key + " on " + String.valueOf(bean), (Throwable)e);
            r = null;
        }
        return (T)r;
    }
}

