/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.docker.common;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Container;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class ContainerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContainerUtils.class);

    private static Set<String> getContainerIdCandidates() throws IOException {
        String candidate;
        String candidate2;
        String cpuset;
        String[] parts;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Path path = Paths.get("/proc/self/cgroup", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(Paths.get("/proc/self/cgroup", new String[0]));
            for (String line : lines) {
                String candidate3;
                String[] parts2 = line.split("/");
                if (parts2.length <= 1 || !ContainerUtils.isLikelyContainerId(candidate3 = parts2[parts2.length - 1])) continue;
                result.add(candidate3);
            }
        }
        if (Files.exists(path = Paths.get("/proc/1/cpuset", new String[0]), new LinkOption[0]) && (parts = (cpuset = Files.readString(path).trim()).split("/")).length > 0 && ContainerUtils.isLikelyContainerId(candidate2 = parts[parts.length - 1])) {
            result.add(candidate2);
        }
        if (Files.exists(path = Paths.get("/etc/hostname", new String[0]), new LinkOption[0]) && (candidate = Files.readString(path).trim()) != null) {
            result.add(candidate);
        }
        return result;
    }

    public static InspectContainerResponse findSelfByHostname() throws IOException {
        String myHostname = Files.readString(Path.of("/etc/hostname", new String[0])).trim();
        DockerClient docker = DockerClientFactory.instance().client();
        List containers = (List)docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        for (Container container : containers) {
            InspectContainerResponse inspect = docker.inspectContainerCmd(container.getId()).exec();
            String containerHostname = inspect.getConfig().getHostName();
            if (!myHostname.equals(containerHostname)) continue;
            return inspect;
        }
        throw new RuntimeException("Could not find container with hostname: " + myHostname);
    }

    private static boolean isLikelyContainerId(String s) {
        boolean result = s.matches("[a-f0-9]{12,64}");
        logger.info("Is container id: " + s + " -> " + result);
        return result;
    }

    public static InspectContainerResponse detectContainer(DockerClient dockerClient) {
        Set<String> candidateIds;
        try {
            candidateIds = ContainerUtils.getContainerIdCandidates();
        }
        catch (IOException e) {
            logger.warn("Error trying to gather candidate container ids.", (Throwable)e);
            candidateIds = Set.of();
        }
        logger.info("Candidate container ids: " + String.valueOf(candidateIds));
        InspectContainerResponse result = null;
        for (String candidateId : candidateIds) {
            try {
                result = dockerClient.inspectContainerCmd(candidateId).exec();
            }
            catch (Exception e) {
                logger.info("Inspection failed for candidate containerId " + candidateId + ". Trying next.", (Throwable)e);
            }
        }
        if (result != null) {
            logger.info("Detected container ID: " + result.getId());
        } else {
            logger.info("No container environment detected.");
        }
        return result;
    }
}

