/*
 * Decompiled with CFR 0.152.
 */
package jenax.engine.qlever.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jenax.engine.qlever.docker.ContainerDef;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.core.CreateContainerCmdModifier;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.testcontainers.utility.MountableFile;

public class GenericContainer<SELF extends GenericContainer<SELF>>
implements Container<SELF> {
    private ContainerDef containerDef = new ContainerDef();
    private String workingDirectory;
    private final Set<CreateContainerCmdModifier> createContainerCmdModifiers = this.loadCreateContainerCmdCustomizers();
    private Long shmSize;
    private Map<String, String> tmpFsMapping;

    public String[] buildCmdLine() {
        String user;
        ArrayList<String> parts = new ArrayList<String>();
        DockerClient dockerClient = DockerClientFactory.lazyClient();
        String dockerImageName = this.getDockerImageName();
        CreateContainerCmd cmd = dockerClient.createContainerCmd(dockerImageName);
        this.applyConfiguration(cmd);
        parts.add("docker");
        parts.add("run");
        parts.add("-i");
        if (cmd.getWorkingDir() != null) {
            parts.add("-w");
            parts.add(this.workingDirectory);
        }
        if ((user = cmd.getUser()) != null) {
            parts.add("-u");
            parts.add(user);
        }
        for (Bind bind : cmd.getBinds()) {
            parts.add("-v");
            parts.add(bind.toString());
        }
        parts.add(this.getDockerImageName());
        parts.addAll(Arrays.asList(cmd.getCmd()));
        String[] result = parts.toArray(new String[0]);
        return result;
    }

    public GenericContainer(String imageName) {
        this.setDockerImageName(imageName);
    }

    private Set<CreateContainerCmdModifier> loadCreateContainerCmdCustomizers() {
        ServiceLoader<CreateContainerCmdModifier> containerCmdCustomizers = ServiceLoader.load(CreateContainerCmdModifier.class);
        LinkedHashSet<CreateContainerCmdModifier> loadedCustomizers = new LinkedHashSet<CreateContainerCmdModifier>();
        for (CreateContainerCmdModifier customizer : containerCmdCustomizers) {
            loadedCustomizers.add(customizer);
        }
        return loadedCustomizers;
    }

    private HostConfig buildHostConfig(HostConfig config) {
        if (this.shmSize != null) {
            config.withShmSize(this.shmSize);
        }
        if (this.tmpFsMapping != null) {
            config.withTmpFs(this.tmpFsMapping);
        }
        return config;
    }

    private void applyConfiguration(CreateContainerCmd createCommand) {
        this.containerDef.applyTo(createCommand);
        this.buildHostConfig(createCommand.getHostConfig());
        if (this.workingDirectory != null) {
            createCommand.withWorkingDir(this.workingDirectory);
        }
        for (CreateContainerCmdModifier createContainerCmdModifier : this.createContainerCmdModifiers) {
            createCommand = createContainerCmdModifier.modify(createCommand);
        }
    }

    public SELF withCreateContainerCmdModifier(Consumer<CreateContainerCmd> modifier) {
        this.createContainerCmdModifiers.add(cmd -> {
            modifier.accept(cmd);
            return cmd;
        });
        return (SELF)((GenericContainer)this.self());
    }

    public String getContainerName() {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getExposedPorts() {
        return this.containerDef.getPortBindings().stream().map(PortBinding::getExposedPort).map(ExposedPort::getPort).toList();
    }

    public InspectContainerResponse getContainerInfo() {
        throw new UnsupportedOperationException();
    }

    public void setCommand(@NonNull String command) {
        this.containerDef.setCommand(command.split(" "));
    }

    public void setCommand(String ... commandParts) {
        this.containerDef.setCommand(commandParts);
    }

    public void addEnv(String key, String value) {
        this.containerDef.addEnvVar(key, value);
    }

    public void addLink(LinkableContainer otherContainer, String alias) {
        throw new UnsupportedOperationException();
    }

    public void addExposedPort(Integer port) {
        this.containerDef.addExposedTcpPort(port);
    }

    public void addExposedPorts(int ... ports) {
        this.containerDef.addExposedTcpPorts(ports);
    }

    public SELF waitingFor(@NonNull WaitStrategy waitStrategy) {
        throw new UnsupportedOperationException();
    }

    public SELF withFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.addFileSystemBind(hostPath, containerPath, mode);
        return (SELF)((GenericContainer)this.self());
    }

    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        if (SystemUtils.IS_OS_WINDOWS && hostPath.startsWith("/")) {
            this.containerDef.addBinds(new Bind(hostPath, new Volume(containerPath), mode.accessMode, selinuxContext.selContext));
        } else {
            MountableFile mountableFile = MountableFile.forHostPath((String)hostPath);
            this.containerDef.addBinds(new Bind(mountableFile.getResolvedPath(), new Volume(containerPath), mode.accessMode, selinuxContext.selContext));
        }
    }

    public SELF withVolumesFrom(Container container, BindMode mode) {
        return null;
    }

    public SELF withExposedPorts(Integer ... ports) {
        this.setExposedPorts(List.of(ports));
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withCopyFileToContainer(MountableFile mountableFile, String containerPath) {
        throw new UnsupportedOperationException();
    }

    public SELF withCopyToContainer(Transferable transferable, String containerPath) {
        throw new UnsupportedOperationException();
    }

    public SELF withEnv(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public SELF withEnv(Map<String, String> env) {
        throw new UnsupportedOperationException();
    }

    public SELF withLabel(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public SELF withLabels(Map<String, String> labels) {
        throw new UnsupportedOperationException();
    }

    public SELF withCommand(String cmd) {
        this.setCommand(cmd);
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withCommand(String ... commandParts) {
        this.setCommand(commandParts);
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withExtraHost(String hostname, String ipAddress) {
        throw new UnsupportedOperationException();
    }

    public SELF withNetworkMode(String networkMode) {
        throw new UnsupportedOperationException();
    }

    public SELF withNetwork(Network network) {
        throw new UnsupportedOperationException();
    }

    public SELF withNetworkAliases(String ... aliases) {
        throw new UnsupportedOperationException();
    }

    public SELF withImagePullPolicy(ImagePullPolicy policy) {
        throw new UnsupportedOperationException();
    }

    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        throw new UnsupportedOperationException();
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        throw new UnsupportedOperationException();
    }

    public SELF withPrivilegedMode(boolean mode) {
        throw new UnsupportedOperationException();
    }

    public SELF withMinimumRunningDuration(Duration minimumRunningDuration) {
        throw new UnsupportedOperationException();
    }

    public SELF withStartupCheckStrategy(StartupCheckStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    public SELF withWorkingDirectory(String workDir) {
        this.workingDirectory = workDir;
        return (SELF)((GenericContainer)this.self());
    }

    public void setDockerImageName(@NonNull String dockerImageName) {
        this.containerDef.setImage(new RemoteDockerImage(dockerImageName));
    }

    public String getDockerImageName() {
        RemoteDockerImage image = this.containerDef.getImage();
        try {
            return (String)image.get();
        }
        catch (Exception e) {
            throw new ContainerFetchException("Can't get Docker image: " + String.valueOf(image), e);
        }
    }

    public String getTestHostIpAddress() {
        throw new UnsupportedOperationException();
    }

    public SELF withLogConsumer(Consumer<OutputFrame> consumer) {
        throw new UnsupportedOperationException();
    }

    public List<String> getPortBindings() {
        return this.containerDef.getPortBindings().stream().map(it -> String.format("%s:%s", it.getBinding(), it.getExposedPort())).toList();
    }

    public List<String> getExtraHosts() {
        throw new UnsupportedOperationException();
    }

    public Future<String> getImage() {
        return this.containerDef.getImage();
    }

    public List<String> getEnv() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getEnvMap() {
        return this.containerDef.getEnvVars();
    }

    public String[] getCommandParts() {
        return this.containerDef.getCommand();
    }

    public List<Bind> getBinds() {
        return this.containerDef.getBinds();
    }

    public Map<String, LinkableContainer> getLinkedContainers() {
        throw new UnsupportedOperationException();
    }

    public void setExposedPorts(List<Integer> exposedPorts) {
        throw new UnsupportedOperationException();
    }

    public void setPortBindings(List<String> portBindings) {
        this.containerDef.setPortBindings(portBindings.stream().map(PortBinding::parse).collect(Collectors.toSet()));
    }

    public void setExtraHosts(List<String> extraHosts) {
        throw new UnsupportedOperationException();
    }

    public void setImage(Future<String> image) {
        this.containerDef.setImage(new RemoteDockerImage(image));
    }

    public void setEnv(List<String> env) {
        this.containerDef.setEnvVars(this.getEnvMap());
    }

    public void setCommandParts(String[] commandParts) {
        this.containerDef.setCommand(commandParts);
    }

    public void setBinds(List<Bind> binds) {
        this.containerDef.setBinds(binds);
    }

    public void setLinkedContainers(Map<String, LinkableContainer> linkedContainers) {
        throw new UnsupportedOperationException();
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        throw new UnsupportedOperationException();
    }
}

