/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transformer;

import java.util.List;
import java.util.Objects;
import org.aksw.shellgebra.algebra.stream.op.HasStreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVar;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVisitor;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformGeneric;

public class StreamOpVisitorApplyTransform<T extends HasStreamOp>
implements StreamOpVisitor<T> {
    protected StreamOpTransformGeneric<T> transform;

    public StreamOpVisitorApplyTransform(StreamOpTransformGeneric<T> transform) {
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public T visit(StreamOpFile op) {
        T result = this.transform.transform(op);
        return result;
    }

    @Override
    public T visit(StreamOpTranscode op) {
        StreamOp subOp = op.getSubOp().getStreamOp();
        HasStreamOp newSubOp = (HasStreamOp)subOp.accept(this);
        HasStreamOp result = this.transform.transform(op, newSubOp);
        return (T)result;
    }

    @Override
    public T visit(StreamOpConcat op) {
        List<HasStreamOp> newSubOps = op.getSubOps().stream().map(HasStreamOp::getStreamOp).map(subOp -> (HasStreamOp)subOp.accept(this)).toList();
        HasStreamOp result = this.transform.transform(op, newSubOps);
        return (T)result;
    }

    @Override
    public T visit(StreamOpCommand op) {
        T result = this.transform.transform(op);
        return result;
    }

    @Override
    public T visit(StreamOpVar op) {
        T result = this.transform.transform(op);
        return result;
    }
}

