/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.qlever;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetMatcher;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetOverPathBase;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetOverPathMatcher;
import org.aksw.jenax.dataaccess.sparql.creator.FileSets;
import org.aksw.jenax.dataaccess.sparql.creator.RDFDatabase;

public class RdfDatabaseQlever
implements RDFDatabase {
    protected Path path;
    protected String indexName;
    protected FileSetOverPathBase fileSet;

    public RdfDatabaseQlever(Path path, String indexName) {
        this.path = Objects.requireNonNull(path);
        this.indexName = Objects.requireNonNull(indexName);
        this.fileSet = RdfDatabaseQlever.getFileSet(path, indexName);
    }

    public static FileSetOverPathBase getFileSet(Path path, String indexName) {
        return new FileSetOverPathMatcher(path, (FileSetMatcher)new FileSetMatcherQlever(indexName));
    }

    public Path getPath() {
        return this.path;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public FileSetOverPathBase getFileSet() {
        return this.fileSet;
    }

    public String toString() {
        return "Qlever database " + this.fileSet.toString();
    }

    public static List<Path> assembleFileSet(Path path, String indexName) {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSets.accumulateIfExists(result, (Path)path.resolve(".stxxl"));
        FileSets.accumulate(result, (Path)path, (String)(indexName + ".*"));
        return result;
    }

    public static class FileSetMatcherQlever
    implements FileSetMatcher {
        protected String indexName;

        public FileSetMatcherQlever(String indexName) {
            this.indexName = Objects.requireNonNull(indexName);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public List<Path> match(Path path) {
            return RdfDatabaseQlever.assembleFileSet(path, this.indexName);
        }
    }
}

