/*
 * Decompiled with CFR 0.152.
 */
package jenax.engine.qlever.docker;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenax.engine.qlever.docker.QleverCliUtils;
import jenax.engine.qlever.docker.QleverConstants;
import jenax.engine.qlever.docker.QleverServerConfig;
import jenax.engine.qlever.docker.QleverServerConfigPojo;
import jenax.engine.qlever.docker.RDFLinkSourceHTTPQlever;
import jenax.engine.qlever.docker.ServiceControlQlever;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetOverPathBase;
import org.aksw.jenax.dataaccess.sparql.creator.RDFDatabase;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.engine.ServiceControl;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineBuilder;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryLegacyBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasic;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.engine.docker.common.ContainerPathResolver;
import org.aksw.jenax.engine.qlever.RdfDatabaseQlever;
import org.aksw.jenax.engine.qlever.SystemUtils;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;

public class RDFEngineBuilderQlever<X extends RDFEngineBuilderQlever<X>>
extends RdfDataSourceSpecBasicFromMap<X>
implements RDFEngineBuilder<X> {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineBuilderQlever.class);
    public static final String INDEX_NAME_KEY = "indexName";
    public static final String IMAGE_NAME_KEY = "imageName";
    public static final String IMAGE_TAG_KEY = "imageTag";
    public static final String CONFIG_KEY = "config";

    public RDFEngineBuilderQlever() {
        this(null, null);
    }

    public RDFEngineBuilderQlever(String qleverImageName, String qleverImageTag) {
        this.setImageName(qleverImageName);
        this.setImageTag(qleverImageTag);
        this.setConfig(new QleverServerConfigPojo());
    }

    public static RDFEngine run(String hostDbDir, String qleverImageName, String qleverImageTag, Integer hostPort, QleverServerConfigPojo conf) throws NumberFormatException, IOException, InterruptedException {
        Integer containerPort;
        ContainerPathResolver cpr = ContainerPathResolver.create();
        if (cpr != null) {
            logger.info("Detected docker-in-docker setup (dind).");
            hostDbDir = ContainerPathResolver.resolvePath(cpr, Path.of(hostDbDir, new String[0])).toAbsolutePath().toString();
        }
        if ((containerPort = conf.getPort()) == null) {
            throw new RuntimeException("Container port must be set.");
        }
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        logger.info("Running as UID: " + uid + ", GID: " + gid);
        ArrayList<String> cmdArgs = new ArrayList<String>();
        QleverCliUtils.accumulateCliOptions(cmdArgs, conf);
        CmdStrOps strOps = SysRuntimeImpl.forCurrentOs().getStrOps();
        String cmdArgStr = cmdArgs.stream().map(strOps::quoteArg).collect(Collectors.joining(" "));
        Object cmdStr = "ServerMain";
        if (!cmdArgStr.isEmpty()) {
            cmdStr = (String)cmdStr + " " + cmdArgStr;
        }
        logger.info("Generated command line: " + (String)cmdStr);
        String dockerImageName = QleverConstants.buildDockerImageName(qleverImageName, qleverImageTag);
        GenericContainer container = new GenericContainer(dockerImageName).withWorkingDirectory("/data").withExposedPorts(new Integer[]{containerPort}).withCreateContainerCmdModifier(cmd -> cmd.withUser(uid + ":" + gid)).withFileSystemBind(hostDbDir, "/data", BindMode.READ_WRITE).withCommand(new String[]{cmdStr});
        if (hostPort != null) {
            container.setPortBindings(List.of(hostPort + ":" + containerPort));
        }
        ServiceControlQlever serviceControl = new ServiceControlQlever(container, conf);
        serviceControl.start();
        container.followOutput(outputFrame -> {
            String msg = outputFrame.getUtf8StringWithoutLineEnding();
            logger.info(msg);
        });
        RDFLinkSourceHTTPQlever linkSource = new RDFLinkSourceHTTPQlever(serviceControl);
        RDFEngine result = RDFEngines.of((RDFLinkSource)linkSource, (ServiceControl)serviceControl, () -> container.stop());
        return result;
    }

    public RDFEngine build() throws Exception {
        RDFEngine result;
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap((Map)this.map);
        RDFEngineFactoryLegacyBase.CloseablePath entry = RDFEngineFactoryLegacyBase.setupPath((String)"rpt-qlever-", (RdfDataSourceSpecBasic)spec);
        Path finalDbPath = entry.path();
        Closeable partialCloseAction = entry.closeable();
        try {
            RdfDatabaseQlever database;
            FileSetOverPathBase fileSet;
            String location = finalDbPath.toString();
            String qleverImageName = this.getImageName();
            String qleverImageTag = this.getImageTag();
            QleverServerConfig conf = this.getConfig();
            String indexName = this.getIndexName();
            if (indexName == null) {
                indexName = "default";
            }
            Integer hostPort = null;
            int defaultContainerPort = 8080;
            QleverServerConfigPojo finalConf = new QleverServerConfigPojo();
            conf.copyInto(finalConf, false);
            finalConf.setIndexBaseName(indexName);
            finalConf.setPort(defaultContainerPort);
            if (Boolean.TRUE.equals(spec.isAutoDeleteIfCreated()) && (fileSet = (database = new RdfDatabaseQlever(finalDbPath, indexName)).getFileSet()).isEmpty()) {
                logger.info("Auto delete enabled and database fileset is empty. Will delete " + String.valueOf(fileSet.getBasePath()));
                Closeable tmp = partialCloseAction;
                partialCloseAction = () -> {
                    try {
                        database.getFileSet().delete();
                    }
                    finally {
                        tmp.close();
                    }
                };
            }
            result = RDFEngineBuilderQlever.run(location, qleverImageName, qleverImageTag, hostPort, finalConf);
            result = RDFEngines.decorate((RDFEngine)result).addCloseAction(partialCloseAction).build();
        }
        catch (Throwable e) {
            partialCloseAction.close();
            throw new RuntimeException(e);
        }
        return result;
    }

    public X setIndexName(String indexName) {
        this.map.put(INDEX_NAME_KEY, indexName);
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public String getIndexName() {
        return (String)this.map.get(INDEX_NAME_KEY);
    }

    public X setImageTag(String imageTag) {
        this.map.put(IMAGE_TAG_KEY, imageTag);
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public String getImageTag() {
        return (String)this.map.get(IMAGE_TAG_KEY);
    }

    public X setImageName(String imageName) {
        this.map.put(IMAGE_NAME_KEY, imageName);
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public String getImageName() {
        return (String)this.map.get(IMAGE_NAME_KEY);
    }

    public X setConfig(QleverServerConfigPojo qleverConfRun) {
        this.map.put(CONFIG_KEY, qleverConfRun);
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public QleverServerConfig getConfig() {
        return (QleverServerConfig)this.map.get(CONFIG_KEY);
    }

    public X setProperty(String key, Object value) {
        this.map.put(key, value);
        try {
            logger.info("Setting attribute: " + key + " -> " + String.valueOf(value));
            try {
                QleverServerConfig runConf = this.getConfig();
                BeanUtils.setProperty((Object)runConf, (String)key, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("Error:", (Throwable)e);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to set attribute: " + key + " -> " + String.valueOf(value), e);
        }
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public X setDatabase(RDFDatabase database) {
        if (!(database instanceof RdfDatabaseQlever)) {
            throw new IllegalArgumentException("Argument is not a qlever database: " + String.valueOf(database));
        }
        RdfDatabaseQlever db = (RdfDatabaseQlever)database;
        this.map.put("database", db);
        Path path = db.getPath().toAbsolutePath();
        this.setLocationContext(null);
        this.setLocation(path.toString());
        this.setIndexName(db.getIndexName());
        return (X)((Object)((RDFEngineBuilderQlever)((Object)this.self())));
    }

    public RDFDatabase getDatabase() {
        return (RDFDatabase)this.map.get("database");
    }
}

