/*
 * Decompiled with CFR 0.152.
 */
package jenax.engine.qlever.docker;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenax.engine.qlever.docker.QleverCliUtils;
import jenax.engine.qlever.docker.QleverServerConfigPojo;
import org.aksw.jenax.engine.qlever.SystemUtils;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;

public class QleverRunner {
    private static final Logger logger = LoggerFactory.getLogger(QleverRunner.class);

    public static void run(String hostDbDir, String qleverImageName, String qleverImageTag, Integer hostPort, QleverServerConfigPojo conf) throws NumberFormatException, IOException, InterruptedException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        logger.info("Running as UID: " + uid + ", GID: " + gid);
        ArrayList<String> cmdArgs = new ArrayList<String>();
        QleverCliUtils.accumulateCliOptions(cmdArgs, conf);
        CmdStrOps strOps = SysRuntimeImpl.forCurrentOs().getStrOps();
        String cmdArgStr = cmdArgs.stream().map(strOps::quoteArg).collect(Collectors.joining(" "));
        Object cmdStr = "ServerMain";
        if (!cmdArgStr.isEmpty()) {
            cmdStr = (String)cmdStr + " " + cmdArgStr;
        }
        logger.info("Generated command line: " + (String)cmdStr);
        if (qleverImageName == null) {
            qleverImageName = "adfreiburg/qlever";
        }
        if (qleverImageTag == null) {
            qleverImageTag = "commit-a307781";
        }
        String dockerImageName = Stream.of(qleverImageName, qleverImageTag).filter(x -> x != null).collect(Collectors.joining(":"));
        int defaultContainerPort = 8080;
        int containerPort = Optional.ofNullable(conf.getPort()).orElse(defaultContainerPort);
        try (GenericContainer container = new GenericContainer(dockerImageName).withWorkingDirectory("/data").withExposedPorts(new Integer[]{containerPort}).withCreateContainerCmdModifier(cmd -> cmd.withUser(uid + ":" + gid)).withFileSystemBind(hostDbDir, "/data", BindMode.READ_WRITE).withCommand(new String[]{cmdStr});){
            if (hostPort != null) {
                container.setPortBindings(List.of(hostPort + ":" + containerPort));
            }
            container.start();
            String serviceUrl = "http://" + container.getHost() + ":" + container.getMappedPort(containerPort);
            logger.info("Started Qlever server at: " + serviceUrl);
            container.followOutput(outputFrame -> {
                String msg = outputFrame.getUtf8StringWithoutLineEnding();
                logger.info(msg);
            });
            ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
        }
    }
}

