/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.op;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpN;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpString;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;

public class CmdOpExec
extends CmdOpN {
    protected String name;

    public static CmdOpExec of(String ... cmd) {
        return CmdOpExec.of(Arrays.asList(cmd));
    }

    public static CmdOpExec of(List<String> cmd) {
        return CmdOpExec.ofStrings(cmd.get(0), cmd.subList(1, cmd.size()));
    }

    public static CmdOpExec ofStrings(String name, String ... args) {
        return CmdOpExec.ofStrings(name, Arrays.asList(args));
    }

    public static CmdOpExec ofStrings(String name, List<String> args) {
        return new CmdOpExec(name, args.stream().map(CmdOpString::new).toList());
    }

    public CmdOpExec(String name, List<CmdOp> args) {
        super(args);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <T> T accept(CmdOpVisitor<T> visitor) {
        T result = visitor.visit(this);
        return result;
    }

    public String toString() {
        String argsStr = this.getSubOps().stream().map(Object::toString).collect(Collectors.joining(" "));
        return "(exec (" + this.getName() + ")" + (argsStr.isEmpty() ? "" : " ") + argsStr + ")";
    }
}

