/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.store.qlever.assembler;

import java.io.IOException;
import java.nio.file.Path;
import jenax.engine.qlever.docker.QleverConfRun;
import jenax.engine.qlever.docker.RDFEngineBuilderQlever;
import org.aksw.jenax.dataaccess.sparql.creator.FileSetOverPathBase;
import org.aksw.jenax.dataaccess.sparql.dataset.engine.DatasetGraphOverRDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.engine.qlever.RDFDatabaseBuilderQlever;
import org.aksw.jenax.engine.qlever.RdfDatabaseQlever;
import org.aksw.jenax.store.qlever.assembler.QleverAssemblerVocab;
import org.aksw.jenax.store.qlever.assembler.QleverConfigRdf;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;

public class DatasetAssemblerQlever
extends DatasetAssembler {
    protected DatasetGraph createDataset(Assembler a, Resource root) {
        RDFEngine engine;
        RdfDatabaseQlever db;
        QleverConfigRdf res = new QleverConfigRdf(root.asNode(), (EnhGraph)root.getModel());
        QleverConfRun confRun = new QleverConfRun();
        res.copyInto(confRun, false);
        String location = res.getLocation();
        if (location == null) {
            throw new AssemblerException(root, "Required location is missing: " + String.valueOf(QleverAssemblerVocab.location));
        }
        String indexName = confRun.getIndexBaseName();
        if (indexName == null) {
            throw new AssemblerException(root, "Required index name is missing: " + String.valueOf(QleverAssemblerVocab.indexName));
        }
        Path path = Path.of(location, new String[0]);
        FileSetOverPathBase fileSet = RdfDatabaseQlever.getFileSet(path, indexName);
        try {
            if (!fileSet.isEmpty()) {
                db = new RdfDatabaseQlever(path, indexName);
            } else {
                RDFDatabaseBuilderQlever dbBuilder = new RDFDatabaseBuilderQlever();
                dbBuilder.setIndexName(indexName);
                dbBuilder.setOutputFolder(path);
                db = dbBuilder.build();
                fileSet = db.getFileSet();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        RDFEngineBuilderQlever engineBuilder = new RDFEngineBuilderQlever();
        try {
            engine = ((RDFEngineBuilderQlever)((Object)((RDFEngineBuilderQlever)((Object)engineBuilder.setConfig(confRun))).setDatabase(db))).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DatasetGraphOverRDFEngine result = DatasetGraphOverRDFEngine.of((RDFEngine)engine);
        return result;
    }
}

