/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.qlever;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Volume;
import com.google.common.io.ByteSource;
import com.nimbusds.jose.util.StandardCharset;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenax.engine.qlever.docker.QleverConstants;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jenax.arq.util.prefix.ShortNameMgr;
import org.aksw.jenax.dataaccess.sparql.creator.FileSet;
import org.aksw.jenax.dataaccess.sparql.creator.RDFDatabaseBuilder;
import org.aksw.jenax.engine.docker.common.ContainerPathResolver;
import org.aksw.jenax.engine.qlever.ByteSourceOverStreamOp;
import org.aksw.jenax.engine.qlever.RdfDatabaseQlever;
import org.aksw.jenax.engine.qlever.StreamOpPlanner;
import org.aksw.jenax.engine.qlever.SystemUtils;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpFile;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipe;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpRedirect;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpSubst;
import org.aksw.shellgebra.algebra.common.TranscodeMode;
import org.aksw.shellgebra.algebra.stream.op.CodecSysEnv;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpBase;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.transform.StreamOpTransformExecutionPartitioner;
import org.aksw.shellgebra.algebra.stream.transform.StreamOpTransformSubst;
import org.aksw.shellgebra.algebra.stream.transform.StreamOpTransformToCmdOp;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpEntry;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformer;
import org.aksw.shellgebra.exec.FileWriterTask;
import org.aksw.shellgebra.exec.FileWriterTaskBase;
import org.aksw.shellgebra.exec.FileWriterTaskFromByteSource;
import org.aksw.shellgebra.exec.FileWriterTaskFromProcess;
import org.aksw.shellgebra.exec.FileWriterTaskNoop;
import org.aksw.shellgebra.exec.PathLifeCycles;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.registry.CodecRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class RDFDatabaseBuilderQlever<X extends RDFDatabaseBuilderQlever<X>>
implements RDFDatabaseBuilder<X> {
    public static final List<Lang> supportedLangs = Collections.unmodifiableList(Arrays.asList(Lang.TURTLE, Lang.NQUADS));
    private static final Logger logger = LoggerFactory.getLogger(RDFDatabaseBuilderQlever.class);
    protected String dockerImageName;
    protected String dockerImageTag;
    protected ShortNameMgr shortNameMgr = new ShortNameMgr();
    protected SysRuntime sysRuntime;
    protected Path outputFolder = null;
    protected List<FileArg> args = new ArrayList<FileArg>();
    protected List<Map.Entry<Lang, Throwable>> errorCollector = new ArrayList<Map.Entry<Lang, Throwable>>();
    protected String indexName;
    protected String stxxlMemory = null;
    protected String containerFifoPath = "/fifo/";
    protected ContainerPathResolver containerPathResolver = ContainerPathResolver.create();

    public RDFDatabaseBuilderQlever() {
        if (this.containerPathResolver != null) {
            logger.info("Detected docker-in-docker setup (dind).");
        }
    }

    public X setSysRuntime(SysRuntime sysRuntime) {
        this.sysRuntime = sysRuntime;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public X setDockerImageName(String dockerImageName) {
        this.dockerImageName = dockerImageName;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public X setDockerImageTag(String dockerImageTag) {
        this.dockerImageTag = dockerImageTag;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public String getDockerImageTag() {
        return this.dockerImageTag;
    }

    public X setName(String name) {
        return this.setIndexName(name);
    }

    public X setIndexName(String name) {
        this.indexName = name;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public X setOutputFolder(Path outputFolder) {
        this.outputFolder = outputFolder;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public X setStxxlMemory(String stxxlMemory) {
        this.stxxlMemory = stxxlMemory;
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    public String getStxxlMemory() {
        return this.stxxlMemory;
    }

    public X addPath(String source, Node g) throws IOException {
        Path path = Path.of(source, new String[0]);
        RdfEntityInfo entityInfo = RDFDataMgrEx.probeEntityInfo(() -> Files.newInputStream(path, StandardOpenOption.READ), supportedLangs);
        String contentType = entityInfo.getContentType();
        Lang lang = RDFLanguages.contentTypeToLang((String)contentType);
        this.addPath(path, g, entityInfo.getContentEncodings(), lang);
        return (X)((RDFDatabaseBuilderQlever)this.self());
    }

    protected void addPath(Path source, Node graph, List<String> encodings, Lang lang) {
        FileArg arg = new FileArg(source, lang, encodings, graph);
        this.args.add(arg);
    }

    public StreamOp convertArgToOp(FileArg arg) {
        Path path = arg.path();
        StreamOpBase result = new StreamOpFile(path.toString());
        for (String encoding : arg.encodings()) {
            result = new StreamOpTranscode(encoding, TranscodeMode.DECODE, result);
        }
        return result;
    }

    protected SysRuntime getRuntime() {
        SysRuntime result = this.sysRuntime;
        if (result == null) {
            result = SysRuntimeImpl.forCurrentOs();
        }
        return result;
    }

    protected StreamOpTransformToCmdOp sysCallTransform() {
        CodecRegistry reg = CodecRegistry.get();
        SysRuntime runtime = this.getRuntime();
        CodecSysEnv env = new CodecSysEnv(runtime);
        StreamOpTransformToCmdOp sysCallTransform = new StreamOpTransformToCmdOp(reg, env);
        return sysCallTransform;
    }

    protected ByteSourceSpec buildByteSourceCmd(List<StreamOp> args, Lang lang) {
        ByteSourceSpec result;
        args = args.stream().map(x -> {
            StreamOp streamOp;
            if (x instanceof StreamOpFile) {
                StreamOpFile f = (StreamOpFile)x;
                streamOp = new StreamOpTranscode("cat", TranscodeMode.DECODE, f);
            } else {
                streamOp = x;
            }
            return streamOp;
        }).toList();
        StreamOpTransformToCmdOp sysCallTransform = this.sysCallTransform();
        StreamOp javaOp = StreamOpConcat.of(args);
        SysRuntime sysRuntime = SysRuntimeImpl.forCurrentOs();
        ByteSourceOverStreamOp javaByteSource = new ByteSourceOverStreamOp(javaOp);
        StreamOp sysOp = StreamOpTransformer.transform(javaOp, sysCallTransform);
        if (sysOp instanceof StreamOpCommand) {
            StreamOpCommand codecOp = (StreamOpCommand)sysOp;
            CmdOp cmdOp = codecOp.getCmdOp();
            result = new ByteSourceSpec(cmdOp, javaByteSource, lang);
        } else {
            result = new ByteSourceSpec(null, javaByteSource, lang);
        }
        return result;
    }

    protected InputSpec buildInputSpec(Supplier<Path> hostTempPath) throws NoSuchFileException {
        ArrayList<DockerDataArgumentBridge> dataBridges = new ArrayList<DockerDataArgumentBridge>(this.args.size());
        for (FileArg fileArg : this.args) {
            Lang lang = fileArg.lang();
            Node graph = fileArg.graph();
            StreamOp op = this.convertArgToOp(fileArg);
            DockerDataArgumentBridge fileSpec = this.buildHostToContainerDataBridge(hostTempPath, op, graph, lang);
            dataBridges.add(fileSpec);
        }
        return new InputSpec(dataBridges);
    }

    protected FileAndCmd buildCmdPart(String containerBasePath, StreamOp containerOp, String fileArg, Node graph, Lang lang) {
        if (containerOp instanceof StreamOpFile) {
            StreamOpFile opFile = (StreamOpFile)containerOp;
            CmdOpFile cmdOp = new CmdOpFile(opFile.getPath());
        } else {
            StreamOpTransformToCmdOp sysCallTransform = this.sysCallTransform();
            StreamOp sysOp = StreamOpTransformer.transform(containerOp, sysCallTransform);
            if (sysOp instanceof StreamOpCommand) {
                StreamOpCommand streamOpCmd = (StreamOpCommand)sysOp;
                CmdOp cmdOp = streamOpCmd.getCmdOp();
                cmdOp = new CmdOpSubst(cmdOp);
            } else {
                throw new IllegalStateException("Op unexpectedly did not compile to a command.");
            }
        }
        SysRuntime sysRuntime = this.getRuntime();
        String uriStr = fileArg;
        String shortName = this.shortNameMgr.allocate(uriStr).localName();
        String filePath = containerBasePath + shortName;
        String graphArg = Optional.ofNullable(graph).filter(Node::isURI).filter(g -> !Quad.isDefaultGraph((Node)g)).map(Node::getURI).orElse("-");
        String fmtArg = Optional.ofNullable(lang).map(l -> l.getFileExtensions()).map(l -> l.isEmpty() ? null : (String)l.get(0)).orElse("");
        String[] cmdContrib = new String[]{"-f", filePath, "-F", fmtArg, "-g", graphArg};
        return new FileAndCmd(filePath, cmdContrib);
    }

    protected FileWriterTask createHostFileWriter(Supplier<Path> tempPathSupp, StreamOp sysCallOp) throws NoSuchFileException {
        FileWriterTaskBase hostFileWriter;
        StreamOpTransformToCmdOp sysCallTransform = this.sysCallTransform();
        if (sysCallOp instanceof StreamOpFile) {
            StreamOpFile opFile = (StreamOpFile)sysCallOp;
            String hostFileName = opFile.getPath();
            Path hostPath = Path.of(hostFileName, new String[0]).toAbsolutePath();
            if (!Files.exists(hostPath, new LinkOption[0])) {
                throw new NoSuchFileException(String.valueOf(hostPath));
            }
            hostFileWriter = new FileWriterTaskNoop(hostPath);
        } else {
            Path tempPath = tempPathSupp.get();
            String hostFileName = StreamOpPlanner.streamOpToFileName(sysCallOp);
            String plainFileName = Path.of(hostFileName, new String[0]).getFileName().toString();
            Path hostPath = tempPath.resolve(plainFileName);
            StreamOp sysOp = StreamOpTransformer.transform(sysCallOp, sysCallTransform);
            if (sysOp instanceof StreamOpCommand) {
                StreamOpCommand streamOpCmd = (StreamOpCommand)sysOp;
                CmdOp cmdOp = streamOpCmd.getCmdOp();
                String hostPathStr = hostPath.toString();
                CmdOpRedirect redirectOp = new CmdOpRedirect(hostPathStr, cmdOp);
                SysRuntime runtime = this.getRuntime();
                String[] cmd = runtime.compileCommand(redirectOp);
                hostFileWriter = new FileWriterTaskFromProcess(hostPath, PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe()), cmd);
            } else {
                throw new IllegalStateException("Execution partitioner suggested that operation could be executed via sys call - but sys call generation failed.");
            }
        }
        return hostFileWriter;
    }

    protected DockerDataArgumentBridge buildHostToContainerDataBridge(Supplier<Path> hostTempPathSupp, StreamOp op, Node graph, Lang lang) throws NoSuchFileException {
        String plainFileName;
        FileWriterTask hostFileWriter;
        StreamOpTransformToCmdOp sysCallTransform = this.sysCallTransform();
        StreamOpTransformExecutionPartitioner execPartitioner = new StreamOpTransformExecutionPartitioner(sysCallTransform);
        StreamOpEntry<StreamOpTransformExecutionPartitioner.Location> nonSysCallOpEntry = StreamOpTransformer.transform(op, execPartitioner);
        StreamOp nonSysCallOp = nonSysCallOpEntry.getKey();
        StreamOpTransformExecutionPartitioner.Location location = nonSysCallOpEntry.getValue();
        Map<String, StreamOp> hostOps = execPartitioner.getVarToOp();
        if (location == StreamOpTransformExecutionPartitioner.Location.HANDLED) {
            hostFileWriter = this.createHostFileWriter(hostTempPathSupp, nonSysCallOp);
            plainFileName = hostFileWriter.getOutputPath().getFileName().toString();
        } else {
            Path hostTempPath = hostTempPathSupp.get();
            String hostFileName = StreamOpPlanner.streamOpToFileName(nonSysCallOp, hostOps::get);
            plainFileName = Path.of(hostFileName, new String[0]).getFileName().toString();
            Path hostPath = hostTempPath.resolve(plainFileName);
            StreamOp finalOp = StreamOpTransformSubst.subst(nonSysCallOp, hostOps);
            ByteSourceOverStreamOp javaByteSource = new ByteSourceOverStreamOp(finalOp);
            hostFileWriter = new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe()), javaByteSource);
        }
        FileAndCmd containerFileAndCmd = this.buildCmdPart(this.containerFifoPath, op, plainFileName, graph, lang);
        Path finalHostFileWriterPath = ContainerPathResolver.resolvePath(this.containerPathResolver, hostFileWriter.getOutputPath());
        Bind bind = new Bind(finalHostFileWriterPath.toString(), new Volume(containerFileAndCmd.fileName()), AccessMode.ro);
        DockerDataArgumentBridge result = new DockerDataArgumentBridge(hostFileWriter, bind, containerFileAndCmd.cmd());
        return result;
    }

    protected GenericContainer<?> setupContainer(String indexName, String cmdStr) throws NumberFormatException, IOException, InterruptedException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        logger.info("Setting up qlever indexer container as UID: " + uid + ", GID: " + gid);
        ArrayList<Object> cmdParts = new ArrayList<Object>();
        cmdParts.add("IndexBuilderMain -i " + indexName);
        if (this.stxxlMemory != null && !this.stxxlMemory.isBlank()) {
            cmdParts.add("-m " + this.stxxlMemory);
        }
        if (cmdStr != null) {
            cmdParts.add(cmdStr);
        }
        String str = cmdParts.stream().collect(Collectors.joining(" "));
        logger.info("Start command: " + str);
        String finalImageName = QleverConstants.buildDockerImageName(this.dockerImageName, this.dockerImageTag);
        Path finalOutputFolder = ContainerPathResolver.resolvePath(this.containerPathResolver, this.outputFolder);
        GenericContainer result = new GenericContainer(finalImageName).withWorkingDirectory("/data/").withCreateContainerCmdModifier(cmd -> cmd.withUser(uid + ":" + gid)).withFileSystemBind(finalOutputFolder.toString(), "/data/", BindMode.READ_WRITE).withCommand(new String[]{str}).withLogConsumer(frame -> logger.info(frame.getUtf8StringWithoutLineEnding()));
        return result;
    }

    protected void runContainerWithInputStream(ByteSource byteSource, Lang lang) throws InterruptedException, IOException {
        String finalIndexName = this.getFinalIndexName();
        String fmt = this.langToFormat(lang);
        String optsStr = "-f - -F " + fmt + " -p true";
        logger.info("Attempting to launch container with a JVM-based input stream.");
        GenericContainer container = this.setupContainer(finalIndexName, optsStr).withCreateContainerCmdModifier(cmd -> cmd.withTty(Boolean.valueOf(false)).withStdinOpen(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)));
        container.start();
        System.out.println("Waiting");
        Thread.sleep(2000L);
        System.out.println("Attaching data");
        try (InputStream in = byteSource.openStream();){
            String str = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            System.out.println(str);
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            AttachContainerCmd tmp = container.getDockerClient().attachContainerCmd(container.getContainerId()).withStdIn((InputStream)is);
            ResultCallback.Adapter<Frame> callback = new ResultCallback.Adapter<Frame>(){

                public void onNext(Frame frame) {
                    String msg = new String(frame.getPayload(), StandardCharset.UTF_8);
                    logger.info(msg);
                    super.onNext((Object)frame);
                }
            };
            System.out.println("Waiting");
            Thread.sleep(5000L);
            System.out.println("Awaiting completion");
            ((ResultCallback.Adapter)tmp.exec((ResultCallback)callback)).awaitCompletion();
            System.out.println("Done");
        }
        ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
        container.stop();
    }

    protected void runContainerWithFileArgs(FileSpec fileSpec) throws NumberFormatException, IOException, InterruptedException {
        String finalIndexName = this.getFinalIndexName();
        logger.info("Attempting to launch container with binds and file arg");
        String cmdStr = Arrays.asList(fileSpec.fileArgs).stream().collect(Collectors.joining(" "));
        GenericContainer<?> container = this.setupContainer(finalIndexName, cmdStr);
        for (Bind bind : fileSpec.binds()) {
            BindMode bindMode = AccessMode.ro.equals((Object)bind.getAccessMode()) ? BindMode.READ_ONLY : null;
            container.addFileSystemBind(bind.getPath(), bind.getVolume().getPath(), bindMode);
        }
        container.start();
        ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
    }

    protected String langToFormat(Lang lang) {
        return (String)lang.getFileExtensions().get(0);
    }

    protected jenax.engine.qlever.docker.GenericContainer<?> setupContainerSysCall(String fileName, Lang lang) throws NumberFormatException, IOException, InterruptedException {
        int uid = SystemUtils.getUID();
        int gid = SystemUtils.getGID();
        logger.info("Attempting to launch container via syscall. UID: " + uid + ", GID: " + gid);
        String finalImageName = QleverConstants.buildDockerImageName(this.dockerImageName, this.dockerImageTag);
        String fmt = this.langToFormat(lang);
        Container result = ((jenax.engine.qlever.docker.GenericContainer)new jenax.engine.qlever.docker.GenericContainer(finalImageName).withWorkingDirectory("/data").withCreateContainerCmdModifier(cmd -> cmd.withUser(uid + ":" + gid))).withFileSystemBind(this.outputFolder.toString(), "/data", BindMode.READ_WRITE).withCommand(new String[]{"IndexBuilderMain -i " + this.indexName + " -f " + fileName + " -F " + fmt});
        return result;
    }

    protected void runContainerViaSysCallWithInputStream(ByteSource byteSource, Lang lang) throws InterruptedException, IOException {
        jenax.engine.qlever.docker.GenericContainer<?> container = this.setupContainerSysCall("-", lang);
        CmdOpExec cmdOp = CmdOpExec.of(container.buildCmdLine());
        SysRuntime runtime = this.getRuntime();
        String[] cmd = runtime.compileCommand(cmdOp);
        cmd = runtime.resolveCommand(cmd);
        logger.info("CmdOp:" + String.valueOf(cmdOp));
        logger.info("EffectiveCommand: " + String.valueOf(Arrays.asList(cmd)));
        Process process = SystemUtils.run(arg_0 -> ((Logger)logger).info(arg_0), cmd);
        try (OutputStream out = process.getOutputStream();){
            try (InputStream in = byteSource.openStream();){
                in.transferTo(out);
            }
            out.flush();
        }
        process.waitFor();
        int exitValue = process.exitValue();
        if (exitValue != 0) {
            throw new RuntimeException("Process failed, exit value: " + exitValue);
        }
    }

    protected void runContainerViaSysCall(CmdOp generatorCmd, Lang lang) throws NumberFormatException, IOException, InterruptedException {
        jenax.engine.qlever.docker.GenericContainer<?> container = this.setupContainerSysCall("-", lang);
        String[] cmdLine = container.buildCmdLine();
        CmdOpPipe pipe = new CmdOpPipe(generatorCmd, CmdOpExec.of(cmdLine));
        SysRuntime runtime = this.getRuntime();
        String[] cmd = runtime.compileCommand(pipe);
        logger.info("CmdOp:" + String.valueOf(pipe));
        logger.info("EffectiveCommand: " + String.valueOf(Arrays.asList(cmd)));
        Process process = SystemUtils.run(arg_0 -> ((Logger)logger).info(arg_0), cmd);
        process.waitFor();
        int exitValue = process.exitValue();
        if (exitValue != 0) {
            throw new RuntimeException("Process failed, exit value: " + exitValue);
        }
    }

    public String getFinalIndexName() {
        String finalIndexName = this.indexName == null ? "default" : this.indexName;
        return finalIndexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RdfDatabaseQlever build() throws IOException, InterruptedException {
        Path parentFolder = this.outputFolder.getParent();
        if (parentFolder != null && !Files.exists(parentFolder, new LinkOption[0])) {
            throw new NoSuchFileException("Folder does not exist: " + String.valueOf(parentFolder));
        }
        Files.createDirectories(this.outputFolder, new FileAttribute[0]);
        String finalIndexName = this.getFinalIndexName();
        FinallyRunAll closer = FinallyRunAll.create();
        Path[] tempPath = new Path[]{null};
        try {
            Supplier<Path> getHostTempPath = () -> {
                try {
                    Path r = tempPath[0] != null ? tempPath[0] : ContainerPathResolver.resolvePath(this.containerPathResolver, Files.createTempDirectory("qlever-loader", new FileAttribute[0]));
                    logger.info("Created fifo folder: " + String.valueOf(tempPath[0]));
                    return r;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            closer.add(() -> {
                Path p = tempPath[0];
                if (p != null) {
                    try {
                        Files.deleteIfExists(p);
                    }
                    catch (IOException e) {
                        logger.warn("Could not delete fifo folder on host: " + String.valueOf(p), (Throwable)e);
                    }
                }
            });
            InputSpec spec = this.buildInputSpec(getHostTempPath);
            logger.info("Attempting to launch container with binds and file arg");
            SysRuntime runtime = SysRuntimeImpl.forCurrentOs();
            String cmdSuffix = spec.dataBridges().stream().map(DockerDataArgumentBridge::cmdContrib).flatMap(Stream::of).map(arg -> {
                String str = runtime.quoteFileArgument((String)arg);
                return str;
            }).collect(Collectors.joining(" "));
            try (GenericContainer<?> container = this.setupContainer(finalIndexName, cmdSuffix);){
                for (DockerDataArgumentBridge dataBridge : spec.dataBridges()) {
                    Bind bind = dataBridge.bind();
                    BindMode bindMode = AccessMode.ro.equals((Object)bind.getAccessMode()) ? BindMode.READ_ONLY : null;
                    container.addFileSystemBind(bind.getPath(), bind.getVolume().getPath(), bindMode);
                }
                for (DockerDataArgumentBridge dataBridge : spec.dataBridges()) {
                    FileWriterTask task = dataBridge.hostFileWriterTask();
                    closer.addThrowing(task::close);
                    task.start();
                }
                container.start();
                ((WaitContainerResultCallback)container.getDockerClient().waitContainerCmd(container.getContainerId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitCompletion();
            }
        }
        finally {
            closer.run();
        }
        RdfDatabaseQlever result = new RdfDatabaseQlever(this.outputFolder, finalIndexName);
        return result;
    }

    public record FileArg(Path path, Lang lang, List<String> encodings, Node graph) {
    }

    public record ByteSourceSpec(CmdOp cmdOp, ByteSource byteSource, Lang lang) {
    }

    public record DockerDataArgumentBridge(FileWriterTask hostFileWriterTask, Bind bind, String[] cmdContrib) {
    }

    public record InputSpec(List<DockerDataArgumentBridge> dataBridges) {
    }

    public record FileAndCmd(String fileName, String[] cmd) {
    }

    public record FileSpec(String[] fileArgs, List<Bind> binds) {
    }

    public record QleverDbFileSet(List<Path> paths) implements FileSet
    {
        public List<Path> getPaths() {
            return this.paths;
        }
    }
}

