/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.engine.docker.common;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Volume;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class ContainerPathResolver {
    private static final Logger logger = LoggerFactory.getLogger(ContainerPathResolver.class);
    private final Map<Path, Path> containerToHostPaths = new HashMap<Path, Path>();

    private ContainerPathResolver(Map<Path, Path> mountMap) {
        this.containerToHostPaths.putAll(mountMap);
    }

    public static Path resolvePath(ContainerPathResolver containerPathResolver, Path path) {
        Path result;
        if (containerPathResolver != null) {
            result = containerPathResolver.resolve(path);
            logger.info("Resolved container path: " + String.valueOf(path) + " -> " + String.valueOf(result));
        } else {
            result = path;
        }
        return result;
    }

    public static ContainerPathResolver create() {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        InspectContainerResponse containerInfo = ContainerPathResolver.detectContainerId(dockerClient);
        if (containerInfo == null) {
            return null;
        }
        logger.info("Detected container ID: " + containerInfo.getId());
        HashMap<Path, Path> mountMap = new HashMap<Path, Path>();
        for (InspectContainerResponse.Mount mount : containerInfo.getMounts()) {
            String source = mount.getSource();
            Volume destination = mount.getDestination();
            if (source == null || !source.startsWith("/")) continue;
            String destPath = destination.getPath();
            Path containerPath = Paths.get(destPath, new String[0]);
            Path hostPath = Paths.get(source, new String[0]);
            mountMap.put(containerPath, hostPath);
        }
        logger.info("Mount map: " + String.valueOf(mountMap));
        return new ContainerPathResolver(mountMap);
    }

    public Path resolve(Path containerPath) {
        Path result = containerPath;
        for (Map.Entry<Path, Path> entry : this.containerToHostPaths.entrySet()) {
            Path prefix = entry.getKey();
            if (!containerPath.startsWith(prefix)) continue;
            Path relative = prefix.relativize(containerPath);
            result = entry.getValue().resolve(relative);
            break;
        }
        return result;
    }

    private static InspectContainerResponse detectContainerId(DockerClient dockerClient) {
        Set<String> candidateIds;
        try {
            candidateIds = ContainerPathResolver.getContainerIdCandidates();
        }
        catch (IOException e) {
            logger.warn("Error trying to gather candidate container ids.", (Throwable)e);
            candidateIds = Set.of();
        }
        InspectContainerResponse result = null;
        for (String candidateId : candidateIds) {
            try {
                result = dockerClient.inspectContainerCmd(candidateId).exec();
            }
            catch (Exception e) {
                logger.info("Could not inspect candidate containerId.", (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private static Set<String> getContainerIdCandidates() throws IOException {
        String candidate;
        String candidate2;
        String cpuset;
        String[] parts;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Path path = Paths.get("/proc/self/cgroup", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(Paths.get("/proc/self/cgroup", new String[0]));
            for (String line : lines) {
                String candidate3;
                String[] parts2 = line.split("/");
                if (parts2.length <= 1 || !ContainerPathResolver.isLikelyContainerId(candidate3 = parts2[parts2.length - 1])) continue;
                result.add(candidate3);
            }
        }
        if (Files.exists(path = Paths.get("/proc/1/cpuset", new String[0]), new LinkOption[0]) && (parts = (cpuset = Files.readString(path).trim()).split("/")).length > 0 && ContainerPathResolver.isLikelyContainerId(candidate2 = parts[parts.length - 1])) {
            result.add(candidate2);
        }
        if (Files.exists(path = Paths.get("/etc/hostname", new String[0]), new LinkOption[0]) && (candidate = Files.readString(path).trim()) != null) {
            result.add(candidate);
        }
        return result;
    }

    private static boolean isLikelyContainerId(String s) {
        boolean result = s.matches("[a-f0-9]{12,64}");
        logger.info("Is container id: " + s + " -> " + result);
        return result;
    }
}

