/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.aksw.shellgebra.algebra.stream.op.CodecSpec;
import org.aksw.shellgebra.registry.CodecVariant;

public class CodecRegistry {
    private Map<String, CodecSpec> registry = new HashMap<String, CodecSpec>();
    private static CodecRegistry defaultRegistry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodecRegistry get() {
        if (defaultRegistry != null) return defaultRegistry;
        Class<CodecRegistry> clazz = CodecRegistry.class;
        synchronized (CodecRegistry.class) {
            if (defaultRegistry != null) return defaultRegistry;
            defaultRegistry = new CodecRegistry();
            CodecRegistry.loadDefaults(defaultRegistry);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultRegistry;
        }
    }

    public CodecSpec getCodecSpec(String name) {
        return this.registry.get(name);
    }

    public CodecSpec requireCodec(String name) {
        CodecSpec result = this.getCodecSpec(name);
        if (result == null) {
            throw new NoSuchElementException("No codec with name " + name);
        }
        return result;
    }

    public CodecRegistry add(CodecSpec spec) {
        this.registry.put(spec.getName(), spec);
        return this;
    }

    public static void loadDefaults(CodecRegistry registry) {
        CodecSpec spec = new CodecSpec("bzip2");
        spec.getVariants().add(CodecVariant.of("lbzip2", "-cd"));
        spec.getVariants().add(CodecVariant.of("bzip2", "-cd"));
        registry.add(spec);
        spec = new CodecSpec("gz");
        spec.getVariants().add(CodecVariant.of("gzip", "-cd"));
        registry.add(spec);
        spec = new CodecSpec("cat");
        spec.getVariants().add(CodecVariant.of("cat"));
        registry.add(spec);
    }
}

