/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transformer;

import java.util.ArrayList;
import java.util.List;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpFile;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipe;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpRedirect;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpString;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpSubst;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpToArg;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransform;

public class CmdOpApplyTransformVisitor
implements CmdOpVisitor<CmdOp> {
    protected CmdOpTransform transform;

    public CmdOpApplyTransformVisitor(CmdOpTransform transform) {
        this.transform = transform;
    }

    public static List<CmdOp> transformAll(CmdOpVisitor<? extends CmdOp> transform, List<? extends CmdOp> subOps) {
        ArrayList<CmdOp> newOps = new ArrayList<CmdOp>(subOps.size());
        for (CmdOp cmdOp : subOps) {
            CmdOp newOp = cmdOp.accept(transform);
            newOps.add(newOp);
        }
        return newOps;
    }

    @Override
    public CmdOp visit(CmdOpExec op) {
        List<CmdOp> newOps = CmdOpApplyTransformVisitor.transformAll(this, op.getSubOps());
        CmdOp result = this.transform.transform(op, newOps);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpPipe op) {
        CmdOp newOp1 = op.getSubOp1().accept(this);
        CmdOp newOp2 = op.getSubOp2().accept(this);
        CmdOp result = this.transform.transform(op, newOp1, newOp2);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpGroup op) {
        List<CmdOp> newOps = CmdOpApplyTransformVisitor.transformAll(this, op.getSubOps());
        CmdOp result = this.transform.transform(op, newOps);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpString op) {
        CmdOp result = this.transform.transform(op);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpSubst op) {
        CmdOp subOp = op.getSubOp().accept(this);
        CmdOp result = this.transform.transform(op, subOp);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpToArg op) {
        CmdOp subOp = op.getSubOp().accept(this);
        CmdOp result = this.transform.transform(op, subOp);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpFile op) {
        CmdOp result = this.transform.transform(op);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpRedirect op) {
        CmdOp newOp = op.getSubOp().accept(this);
        CmdOp result = this.transform.transform(op, newOp);
        return result;
    }
}

