/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpFile;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipe;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpRedirect;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpString;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpSubst;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpToArg;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.transform.CmdOpTransformLib;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.exec.CmdStrOps;

public class CmdOpVisitorToCmdString
implements CmdOpVisitor<CmdString> {
    protected CmdStrOps strOps;

    public String toArg(CmdString str) {
        String result = str.isScriptString() ? str.scriptString() : this.toArg(str.cmd());
        return result;
    }

    public String toArg(String[] cmd) {
        String result = Stream.concat(Stream.of(cmd[0]), Arrays.asList(cmd).subList(1, cmd.length).stream().map(this.strOps::quoteArg)).collect(Collectors.joining(" "));
        return result;
    }

    public CmdOpVisitorToCmdString(CmdStrOps strOps) {
        this.strOps = Objects.requireNonNull(strOps);
    }

    @Override
    public CmdString visit(CmdOpExec op) {
        List<CmdOp> subOps = op.getSubOps();
        ArrayList<String> argStrs = new ArrayList<String>(1 + subOps.size());
        argStrs.add(op.getName());
        CmdOpTransformLib.transformAll(argStrs, this, subOps, this::toArg);
        CmdString result = new CmdString((String[])argStrs.toArray(String[]::new));
        return result;
    }

    @Override
    public CmdString visit(CmdOpPipe op) {
        String before = this.toArg(op.getSubOp1().accept(this));
        String after = this.toArg(op.getSubOp2().accept(this));
        CmdString result = new CmdString(this.strOps.pipe(before, after));
        return result;
    }

    @Override
    public CmdString visit(CmdOpGroup op) {
        List<String> strs = CmdOpTransformLib.transformAll(this, op.getSubOps(), this::toArg);
        CmdString result = new CmdString(this.strOps.group(strs));
        return result;
    }

    @Override
    public CmdString visit(CmdOpSubst op) {
        String str = this.toArg(op.getSubOp().accept(this));
        CmdString result = new CmdString(this.strOps.subst(str));
        return result;
    }

    @Override
    public CmdString visit(CmdOpString op) {
        return new CmdString(op.getValue());
    }

    @Override
    public CmdString visit(CmdOpToArg op) {
        String str = this.toArg(op.getSubOp().accept(this));
        String result = this.strOps.quoteArg(str);
        return new CmdString(result);
    }

    @Override
    public CmdString visit(CmdOpFile op) {
        String str = op.getPath();
        CmdString result = new CmdString(this.strOps.quoteArg(str));
        return result;
    }

    @Override
    public CmdString visit(CmdOpRedirect op) {
        String before = this.toArg(op.getSubOp().accept(this));
        String fileName = op.getFileName();
        CmdString result = new CmdString(this.strOps.redirect(before, fileName));
        return result;
    }
}

