/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.jena_sparql_api.algebra.transform.ProjectExtend;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.sparql.algebra.topdown.OpRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.impl.ChainingServiceExecutorBulkServiceEnhancer;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfDataSourceWithLocalCacheRework
extends RDFDataSourceWrapperBase<RDFDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(RdfDataSourceWithLocalCacheRework.class);
    public static final String REMOTE_IRI = "env://REMOTE";
    public static final Node REMOTE_NODE = NodeFactory.createURI((String)"env://REMOTE");
    public static final Node CACHE_NODE = NodeFactory.createURI((String)"cache:");
    public Dataset proxyDataset;

    public static void main(String[] args) {
        String queryStr = "SELECT DISTINCT  ?s ?conditionId_1\nWHERE\n  { SELECT  ?s (MIN(str(?o)) AS ?sortKey_1)\n    WHERE\n      { ?s  ?p  ?o\n        FILTER ( ?s IN (<bnode://genid_8777926670064186908_1004>, <urn:view_waynodes>) )\n      }\n    GROUP BY ?s\n    ORDER BY ASC(MIN(str(?o)))\n  }\nORDER BY ASC(?sortKey_1) ?s";
        queryStr = "            SELECT DISTINCT  ?p ?o ?c\nWHERE\n  { SELECT DISTINCT  ?p ?o (COUNT(DISTINCT ?s) AS ?c)\n    WHERE\n      { ?s  a   <http://fp7-pp.publicdata.eu/ontology/Project> ;\n            ?p  ?o\n      }\n    GROUP BY ?p ?o\n    HAVING ( ?p = <http://fp7-pp.publicdata.eu/ontology/strategicObjective> )\n  }\nORDER BY ASC(?p) ASC(?o)\nLIMIT   127\n";
        queryStr = "            SELECT *\nWHERE\n  {{ SELECT DISTINCT  ?p ?o\n    WHERE\n      { SELECT DISTINCT  ?p ?o (COUNT(DISTINCT ?s) AS ?c)\n        WHERE\n          { ?s  a   <http://fp7-pp.publicdata.eu/ontology/Project> ;\n                ?p  ?o\n          }\n        GROUP BY ?p ?o\n      } }\n      FILTER ( ?p = <http://fp7-pp.publicdata.eu/ontology/strategicObjective> )\n  }\n";
        Query query = QueryFactory.create((String)queryStr);
        Op op = Algebra.compile((Query)query);
        Rewrite rewrite = x -> Transformer.transform((Transform)new TransformFilterPlacement(), (Op)x);
        op = rewrite.rewrite(op);
        System.out.println(op);
        RdfDataSourceWithLocalCacheRework dataSource = new RdfDataSourceWithLocalCacheRework(RDFDataSources.of(DatasetFactory.create()));
        Query rewritten = OpRewriteInjectCacheOps.rewriteQuery(query);
        System.out.println(rewritten);
    }

    public RdfDataSourceWithLocalCacheRework(RDFDataSource delegate) {
        super(delegate);
        this.proxyDataset = RdfDataSourceWithLocalCacheRework.createProxyDataset(delegate);
    }

    public static Dataset createProxyDataset(RDFDataSource delegate) {
        Dataset result = DatasetFactory.create();
        ServiceExecutorRegistry registry = new ServiceExecutorRegistry();
        registry.addBulkLink((ChainingServiceExecutorBulk)new ChainingServiceExecutorBulkServiceEnhancer());
        ServiceResponseCache.set((Context)result.getContext(), (ServiceResponseCache)new ServiceResponseCache());
        registry.addSingleLink((opExec, opOrig, binding, execCxt, chain) -> {
            QueryIterator r;
            if (opExec.getService().equals((Object)REMOTE_NODE)) {
                RDFConnection base = delegate.getConnection();
                r = RDFConnectionUtils.execService(binding, execCxt, opExec, base, true, true);
            } else {
                r = chain.createExecution(opExec, opOrig, binding, execCxt);
            }
            return r;
        });
        ServiceExecutorRegistry.set((Context)result.getContext(), (ServiceExecutorRegistry)registry);
        return result;
    }

    @Override
    public RDFConnection getConnection() {
        RDFConnection base = RDFConnection.connect((Dataset)this.proxyDataset);
        RDFConnection result = RDFConnectionUtils.wrapWithQueryTransform(base, OpRewriteInjectCacheOps::rewriteQuery);
        return result;
    }

    public static Map.Entry<Op, Boolean> wrapWithCache(Op op) {
        Map.Entry<Op, Boolean> result = Map.entry(RdfDataSourceWithLocalCacheRework.wrapWithCacheOp(op), true);
        return result;
    }

    public static Op wrapWithCacheOp(Op op) {
        Op remote = RdfDataSourceWithLocalCacheRework.wrapWithRemote(op);
        OpService result = new OpService(CACHE_NODE, remote, false);
        return result;
    }

    public static Op wrapWithRemote(Op op) {
        OpService result = new OpService(REMOTE_NODE, op, false);
        return result;
    }

    public static Op unwrapIfCached(Op op) {
        Op result = ObjectUtils.tryCastAs(OpService.class, (Object)op).filter(x -> CACHE_NODE.equals((Object)x.getService())).map(Op1::getSubOp).flatMap(subOp -> ObjectUtils.tryCastAs(OpService.class, (Object)subOp)).filter(x -> REMOTE_NODE.equals((Object)x.getService())).map(Op1::getSubOp).orElse(null);
        return result;
    }

    public static class OpRewriteInjectCacheOps
    implements OpRewriter<Map.Entry<Op, Boolean>> {
        public static Query rewriteQuery(Query query) {
            if (logger.isDebugEnabled()) {
                logger.debug("OriginalQuery:\n" + String.valueOf(query));
            }
            Query result = QueryUtils.applyOpTransform((Query)query, OpRewriteInjectCacheOps::rewriteOpx);
            return result;
        }

        public static Op rewriteOpx(Op op) {
            Op rr;
            OpRewriteInjectCacheOps rewriter = new OpRewriteInjectCacheOps();
            Map.Entry e = (Map.Entry)rewriter.rewriteOp(op);
            Op op2 = rr = (Boolean)e.getValue() != false ? (Op)e.getKey() : RdfDataSourceWithLocalCacheRework.wrapWithRemote(op);
            if (logger.isDebugEnabled()) {
                logger.debug("Cache rewrite [pushed=" + String.valueOf(e.getValue()) + "]: " + String.valueOf(OpAsQuery.asQuery((Op)rr)));
            }
            return rr;
        }

        public Map.Entry<Op, Boolean> handleOp1(Op1 op, Function<Op, Op> ctor) {
            Op subOp = op.getSubOp();
            Map.Entry tmp = (Map.Entry)this.rewriteOp(subOp);
            Op newSubOp = (Op)tmp.getKey();
            boolean rewritten = (Boolean)tmp.getValue();
            Map.Entry<Op1, Boolean> result = rewritten ? Map.entry(ctor.apply(newSubOp), true) : Map.entry(op, false);
            return result;
        }

        public <T extends Op1> Map.Entry<Op, Boolean> handleProjectExtend(T op, Function<Op, Op> ctor) {
            ProjectExtend pe = ProjectExtend.collect(op);
            Map.Entry<Op, Boolean> result = null;
            Op subOp = op.getSubOp();
            if (pe != null) {
                Op finalSubOp = pe.getSubOp();
                if (finalSubOp instanceof OpGroup) {
                    result = RdfDataSourceWithLocalCacheRework.wrapWithCache(pe.toOp());
                } else {
                    Map.Entry tmp = (Map.Entry)this.rewriteOp(subOp);
                    if (((Boolean)tmp.getValue()).booleanValue()) {
                        result = Map.entry(pe.apply((Op)tmp.getKey()), true);
                    }
                }
            }
            if (result == null) {
                result = this.handleOp1(op, ctor);
            }
            return result;
        }

        public Map.Entry<Op, Boolean> fallback(Op op) {
            return Map.entry(op, false);
        }

        public Map.Entry<Op, Boolean> rewrite(OpFilter op) {
            Map.Entry<Op, Boolean> result = this.handleOp1((Op1)op, subOp -> OpFilter.filterBy((ExprList)op.getExprs(), (Op)subOp));
            return result;
        }

        public Map.Entry<Op, Boolean> rewrite(OpProject op) {
            return this.handleProjectExtend(op, subOp -> new OpProject(subOp, op.getVars()));
        }

        public Map.Entry<Op, Boolean> rewrite(OpExtend op) {
            return this.handleProjectExtend(op, subOp -> OpExtend.create((Op)subOp, (VarExprList)op.getVarExprList()));
        }

        public Map.Entry<Op, Boolean> rewrite(OpSlice op) {
            Map.Entry<Op, Boolean> result = this.handleOp1((Op1)op, subOp -> new OpSlice(subOp, op.getStart(), op.getLength()));
            return result;
        }

        public Map.Entry<Op, Boolean> rewrite(OpDistinct op) {
            Map.Entry<Op, Boolean> result = this.handleOp1((Op1)op, subOp -> new OpDistinct(subOp));
            return result;
        }

        public Map.Entry<Op, Boolean> rewrite(OpOrder op) {
            Map.Entry<Op, Boolean> result = this.handleOp1((Op1)op, subOp -> {
                Op unwrapped = RdfDataSourceWithLocalCacheRework.unwrapIfCached(subOp);
                List rawConditions = op.getConditions();
                Op newSubOp = subOp;
                List conditions = rawConditions;
                if (unwrapped instanceof OpExtend) {
                    OpExtend opExtend = (OpExtend)unwrapped;
                    Map varToExpr = opExtend.getVarExprList().getExprs();
                    HashMap<Var, Var> allocatedVarToActualVar = new HashMap<Var, Var>();
                    for (Map.Entry e : varToExpr.entrySet()) {
                        Var w;
                        Var v2 = (Var)e.getKey();
                        Expr expr = (Expr)e.getValue();
                        if (!expr.isVariable() || !Var.isAllocVar((Node)(w = expr.asVar()))) continue;
                        allocatedVarToActualVar.computeIfAbsent(w, _w -> v2);
                    }
                    if (!allocatedVarToActualVar.isEmpty()) {
                        NodeTransform xform = NodeTransformLib2.wrapWithNullAsIdentity(allocatedVarToActualVar::get);
                        conditions = rawConditions.stream().map(sc -> NodeTransformLib2.transform((NodeTransform)xform, (SortCondition)sc)).collect(Collectors.toList());
                        Set visibleVars = OpVars.visibleVars((Op)opExtend);
                        List exposedVars = visibleVars.stream().filter(v -> !Var.isAllocVar((Node)v)).collect(Collectors.toList());
                        newSubOp = RdfDataSourceWithLocalCacheRework.wrapWithCacheOp((Op)new OpProject((Op)OpExtend.create((Op)opExtend.getSubOp(), (VarExprList)opExtend.getVarExprList()), exposedVars));
                    }
                }
                OpOrder r = new OpOrder(newSubOp, conditions);
                return r;
            });
            return result;
        }

        public Map.Entry<Op, Boolean> rewrite(OpUnion op) {
            Map.Entry a = (Map.Entry)this.rewriteOp(op.getLeft());
            Map.Entry b = (Map.Entry)this.rewriteOp(op.getRight());
            Map.Entry<OpUnion, Boolean> result = (Boolean)a.getValue() != false && (Boolean)b.getValue() != false ? Map.entry(new OpUnion((Op)a.getKey(), (Op)b.getKey()), true) : Map.entry(op, false);
            return result;
        }

        public Map.Entry<Op, Boolean> rewrite(OpGroup op) {
            Map.Entry<OpService, Boolean> result = Map.entry(new OpService(CACHE_NODE, (Op)new OpService(REMOTE_NODE, (Op)op, false), false), true);
            return result;
        }
    }

    public static class TransformInjectCacheSyntax {
        public static boolean canWrapWithCache(Query query) {
            boolean result = query.hasGroupBy() || query.hasAggregators();
            return result;
        }

        public static Query rewriteQuery(Query query) {
            Element newElt;
            Query result = query;
            boolean doWrapAsSubQuery = false;
            Object queryPattern = null;
            if (query.isSelectType()) {
                doWrapAsSubQuery = TransformInjectCacheSyntax.canWrapWithCache(query);
                queryPattern = doWrapAsSubQuery ? new ElementSubQuery(query) : query.getQueryPattern();
            }
            if (queryPattern != null && queryPattern != (newElt = TransformInjectCacheSyntax.rewriteInjectCache(queryPattern))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Original query:\n" + String.valueOf(query));
                }
                if (doWrapAsSubQuery) {
                    if (newElt instanceof ElementSubQuery) {
                        result = ((ElementSubQuery)newElt).getQuery();
                    } else {
                        result = new Query();
                        result.setQuerySelectType();
                        result.setQueryResultStar(true);
                        result.setQueryPattern(newElt);
                    }
                } else {
                    result = QueryTransformOps.shallowCopy((Query)query);
                    result.setQueryPattern(newElt);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Rewritten query:\n" + String.valueOf(result));
                }
            }
            return result;
        }

        public static Element rewriteInjectCacheSubQuery(ElementSubQuery elt) {
            Query newQuery;
            Query oldQuery;
            Query query = elt.getQuery();
            Object result = TransformInjectCacheSyntax.canWrapWithCache(query) ? new ElementService("cache:", (Element)elt) : ((oldQuery = elt.getQuery()) == (newQuery = TransformInjectCacheSyntax.rewriteQuery(elt.getQuery())) ? elt : new ElementSubQuery(newQuery));
            return result;
        }

        public static Element rewriteInjectCache(Element elt) {
            Element result = elt instanceof ElementGroup ? TransformInjectCacheSyntax.rewriteInjectCacheGroup((ElementGroup)elt) : (elt instanceof ElementSubQuery ? TransformInjectCacheSyntax.rewriteInjectCacheSubQuery((ElementSubQuery)elt) : elt);
            return result;
        }

        public static Element rewriteInjectCacheGroup(ElementGroup elts) {
            ElementGroup result = new ElementGroup();
            boolean change = false;
            for (Element elt : elts.getElements()) {
                Element newElt = TransformInjectCacheSyntax.rewriteInjectCache(elt);
                if (newElt != elt) {
                    change = true;
                }
                result.addElement(newElt);
            }
            if (!change) {
                result = elts;
            }
            return result;
        }
    }
}

