/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import java.util.Optional;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.ServiceControl;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.apache.jena.sparql.core.DatasetGraph;

public class RdfDataEngineFromDataset
implements RDFEngine {
    protected RDFLinkSource linkSource;
    protected boolean closeDataset;

    public RdfDataEngineFromDataset(DatasetGraph datasetGraph, boolean closeDataset) {
        this.linkSource = new RDFLinkSourceOverDatasetGraph(datasetGraph);
        this.closeDataset = closeDataset;
    }

    @Override
    public RDFLinkSource getLinkSource() {
        return this.linkSource;
    }

    @Override
    public Optional<ServiceControl> getServiceControl() {
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        if (this.closeDataset) {
            this.linkSource.getDatasetGraph().close();
        }
    }

    public static RdfDataEngineFromDataset create(DatasetGraph datasetGraph, boolean closeDataset) {
        return new RdfDataEngineFromDataset(datasetGraph, closeDataset);
    }

    public static RdfDataEngineFromDataset create(DatasetGraph dataset) {
        return RdfDataEngineFromDataset.create(dataset, true);
    }
}

