/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiplexUtils {
    public static <T> void forEach(Collection<? extends T> items, Consumer<? super T> handler) {
        ArrayList<Exception> throwables = new ArrayList<Exception>();
        for (T item : items) {
            try {
                handler.accept(item);
            }
            catch (Exception e) {
                throwables.add(e);
            }
        }
        if (!throwables.isEmpty()) {
            throw new RuntimeException((Throwable)throwables.iterator().next());
        }
    }

    public static <T, X> X forEachAndReturnFirst(Collection<? extends T> items, Function<? super T, X> handler) {
        ArrayList<Exception> throwables = new ArrayList<Exception>();
        X result = null;
        boolean isFirst = true;
        for (T item : items) {
            try {
                X tmp = handler.apply(item);
                if (!isFirst) continue;
                result = tmp;
                isFirst = false;
            }
            catch (Exception e) {
                throwables.add(e);
            }
        }
        if (!throwables.isEmpty()) {
            throw new RuntimeException((Throwable)throwables.iterator().next());
        }
        return result;
    }
}

