/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.datasource;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecBaseIterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;

public class RdfDataSourceWithSimpleCache
extends RDFDataSourceWrapperBase<RDFDataSource> {
    protected Cache<Object, Object> cache;

    public RdfDataSourceWithSimpleCache(RDFDataSource delegate, Cache<Object, Object> cache) {
        super(delegate);
        this.cache = Objects.requireNonNull(cache);
    }

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    @Override
    public RDFConnection getConnection() {
        RDFConnection result = RDFConnectionUtils.wrapWithBuilderTransform(super.getConnection(), qeb -> new QueryExecBuilderWithSimpleCache((QueryExecBuilder)qeb, this.cache), null);
        return result;
    }

    public static class QueryExecBuilderWithSimpleCache
    extends QueryExecBuilderCustomBase<QueryExecBuilder> {
        protected QueryExecBuilder delegate;
        protected Cache<Object, Object> cache;

        public QueryExecBuilderWithSimpleCache(QueryExecBuilder delegate, Cache<Object, Object> cache) {
            this.delegate = delegate;
            this.cache = cache;
        }

        @Override
        public QueryExec build() {
            this.applySettings(this.delegate);
            Object queryOrQueryString = this.query != null ? this.query : this.queryString;
            Objects.requireNonNull(queryOrQueryString, "No query or query string was set");
            return new QueryExecWithSimpleCache(() -> ((QueryExecBuilder)this.delegate).build(), this.cache, queryOrQueryString);
        }
    }

    public static class QueryExecWithSimpleCache
    extends AutoCloseableWithLeakDetectionBase
    implements QueryExecBaseIterator {
        protected Supplier<QueryExec> queryExecSupplier;
        protected Cache<Object, Object> cache;
        protected Object cacheKey;
        protected volatile QueryExec activeExec;
        protected volatile boolean isCancelled;

        public QueryExecWithSimpleCache(Supplier<QueryExec> queryExecSupplier, Cache<Object, Object> cache, Object cacheKey) {
            this.queryExecSupplier = queryExecSupplier;
            this.cache = cache;
            this.cacheKey = cacheKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            if (!this.isCancelled) {
                QueryExecWithSimpleCache queryExecWithSimpleCache = this;
                synchronized (queryExecWithSimpleCache) {
                    if (!this.isCancelled) {
                        this.isCancelled = true;
                        if (this.activeExec != null) {
                            this.activeExec.abort();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected QueryExec buildExec() {
            QueryExecWithSimpleCache queryExecWithSimpleCache = this;
            synchronized (queryExecWithSimpleCache) {
                this.ensureOpen();
                if (this.activeExec != null) {
                    throw new RuntimeException("QueryExec already started");
                }
                if (this.isCancelled) {
                    throw new QueryCancelledException();
                }
                this.activeExec = this.queryExecSupplier.get();
            }
            return this.activeExec;
        }

        public Object getCacheKey() {
            return this.cacheKey;
        }

        public Cache<Object, Object> getCache() {
            return this.cache;
        }

        protected <T> T get(String category, Function<QueryExec, T> queryExecAccessor) {
            Map.Entry<String, Object> finalKey = Map.entry(category, this.cacheKey);
            Object tmp = this.cache.get(finalKey, k -> {
                Exception r;
                try (QueryExec qe = this.buildExec();){
                    try {
                        r = queryExecAccessor.apply(qe);
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            e.addSuppressed(new RuntimeException("Query execution error"));
                        }
                        r = e;
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        e.addSuppressed(new RuntimeException("Query execution error"));
                    }
                    r = e;
                }
                return r;
            });
            if (tmp instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)tmp;
                throw re;
            }
            if (tmp instanceof Exception) {
                Exception e = (Exception)tmp;
                throw new RuntimeException(e);
            }
            return (T)tmp;
        }

        public RowSet select() {
            Table table = this.get("select", qe -> TableUtils.createTable((RowSet)qe.select()));
            return table.toRowSet();
        }

        public Iterator<Triple> constructTriples() {
            List list = this.get("constructTriples", qe -> Iter.asStream((Iterator)qe.constructTriples()).collect(Collectors.toList()));
            return list.iterator();
        }

        public Iterator<Triple> describeTriples() {
            List list = this.get("describeTriples", qe -> Iter.asStream((Iterator)qe.describeTriples()).collect(Collectors.toList()));
            return list.iterator();
        }

        public Iterator<Quad> constructQuads() {
            List list = this.get("constructQuads", qe -> Iter.asStream((Iterator)qe.constructQuads()).collect(Collectors.toList()));
            return list.iterator();
        }

        public Iterator<JsonObject> execJsonItems() {
            List list = this.get("jsonItems", qe -> Iter.asStream((Iterator)qe.execJsonItems()).collect(Collectors.toList()));
            return list.iterator();
        }

        public boolean ask() {
            Boolean result = this.get("ask", QueryExec::ask);
            return result;
        }

        public DatasetGraph getDataset() {
            return null;
        }

        public Context getContext() {
            return null;
        }

        public Query getQuery() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

